package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ResourceClaimBuilder extends ResourceClaimFluentImpl<ResourceClaimBuilder> implements VisitableBuilder<ResourceClaim,ResourceClaimBuilder>{
  public ResourceClaimBuilder() {
    this(false);
  }
  public ResourceClaimBuilder(Boolean validationEnabled) {
    this(new ResourceClaim(), validationEnabled);
  }
  public ResourceClaimBuilder(ResourceClaimFluent<?> fluent) {
    this(fluent, false);
  }
  public ResourceClaimBuilder(ResourceClaimFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ResourceClaim(), validationEnabled);
  }
  public ResourceClaimBuilder(ResourceClaimFluent<?> fluent,ResourceClaim instance) {
    this(fluent, instance, false);
  }
  public ResourceClaimBuilder(ResourceClaimFluent<?> fluent,ResourceClaim instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ResourceClaimBuilder(ResourceClaim instance) {
    this(instance,false);
  }
  public ResourceClaimBuilder(ResourceClaim instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withName(instance.getName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ResourceClaimFluent<?> fluent;
  Boolean validationEnabled;
  public ResourceClaim build() {
    ResourceClaim buildable = new ResourceClaim(fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}