package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ResourceQuotaBuilder extends ResourceQuotaFluentImpl<ResourceQuotaBuilder> implements VisitableBuilder<ResourceQuota,ResourceQuotaBuilder>{
  public ResourceQuotaBuilder() {
    this(false);
  }
  public ResourceQuotaBuilder(Boolean validationEnabled) {
    this(new ResourceQuota(), validationEnabled);
  }
  public ResourceQuotaBuilder(ResourceQuotaFluent<?> fluent) {
    this(fluent, false);
  }
  public ResourceQuotaBuilder(ResourceQuotaFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ResourceQuota(), validationEnabled);
  }
  public ResourceQuotaBuilder(ResourceQuotaFluent<?> fluent,ResourceQuota instance) {
    this(fluent, instance, false);
  }
  public ResourceQuotaBuilder(ResourceQuotaFluent<?> fluent,ResourceQuota instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ResourceQuotaBuilder(ResourceQuota instance) {
    this(instance,false);
  }
  public ResourceQuotaBuilder(ResourceQuota instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ResourceQuotaFluent<?> fluent;
  Boolean validationEnabled;
  public ResourceQuota build() {
    ResourceQuota buildable = new ResourceQuota(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}