package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface ResourceRequirementsFluent<A extends ResourceRequirementsFluent<A>> extends Fluent<A>{
  public A addToClaims(int index,ResourceClaim item);
  public A setToClaims(int index,ResourceClaim item);
  public A addToClaims(io.fabric8.kubernetes.api.model.ResourceClaim... items);
  public A addAllToClaims(Collection<ResourceClaim> items);
  public A removeFromClaims(io.fabric8.kubernetes.api.model.ResourceClaim... items);
  public A removeAllFromClaims(Collection<ResourceClaim> items);
  public A removeMatchingFromClaims(Predicate<ResourceClaimBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildClaims instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ResourceClaim> getClaims();
  public List<ResourceClaim> buildClaims();
  public ResourceClaim buildClaim(int index);
  public ResourceClaim buildFirstClaim();
  public ResourceClaim buildLastClaim();
  public ResourceClaim buildMatchingClaim(Predicate<ResourceClaimBuilder> predicate);
  public Boolean hasMatchingClaim(Predicate<ResourceClaimBuilder> predicate);
  public A withClaims(List<ResourceClaim> claims);
  public A withClaims(io.fabric8.kubernetes.api.model.ResourceClaim... claims);
  public Boolean hasClaims();
  public A addNewClaim(String name);
  public ResourceRequirementsFluent.ClaimsNested<A> addNewClaim();
  public ResourceRequirementsFluent.ClaimsNested<A> addNewClaimLike(ResourceClaim item);
  public ResourceRequirementsFluent.ClaimsNested<A> setNewClaimLike(int index,ResourceClaim item);
  public ResourceRequirementsFluent.ClaimsNested<A> editClaim(int index);
  public ResourceRequirementsFluent.ClaimsNested<A> editFirstClaim();
  public ResourceRequirementsFluent.ClaimsNested<A> editLastClaim();
  public ResourceRequirementsFluent.ClaimsNested<A> editMatchingClaim(Predicate<ResourceClaimBuilder> predicate);
  public A addToLimits(String key,Quantity value);
  public A addToLimits(Map<String,Quantity> map);
  public A removeFromLimits(String key);
  public A removeFromLimits(Map<String,Quantity> map);
  public Map<String,Quantity> getLimits();
  public <K,V>A withLimits(Map<String,Quantity> limits);
  public Boolean hasLimits();
  public A addToRequests(String key,Quantity value);
  public A addToRequests(Map<String,Quantity> map);
  public A removeFromRequests(String key);
  public A removeFromRequests(Map<String,Quantity> map);
  public Map<String,Quantity> getRequests();
  public <K,V>A withRequests(Map<String,Quantity> requests);
  public Boolean hasRequests();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ClaimsNested<N> extends Nested<N>,ResourceClaimFluent<ResourceRequirementsFluent.ClaimsNested<N>>{
    public N and();
    public N endClaim();
    
  }
  
}