package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ScaleIOPersistentVolumeSourceBuilder extends ScaleIOPersistentVolumeSourceFluentImpl<ScaleIOPersistentVolumeSourceBuilder> implements VisitableBuilder<ScaleIOPersistentVolumeSource,ScaleIOPersistentVolumeSourceBuilder>{
  public ScaleIOPersistentVolumeSourceBuilder() {
    this(false);
  }
  public ScaleIOPersistentVolumeSourceBuilder(Boolean validationEnabled) {
    this(new ScaleIOPersistentVolumeSource(), validationEnabled);
  }
  public ScaleIOPersistentVolumeSourceBuilder(ScaleIOPersistentVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public ScaleIOPersistentVolumeSourceBuilder(ScaleIOPersistentVolumeSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ScaleIOPersistentVolumeSource(), validationEnabled);
  }
  public ScaleIOPersistentVolumeSourceBuilder(ScaleIOPersistentVolumeSourceFluent<?> fluent,ScaleIOPersistentVolumeSource instance) {
    this(fluent, instance, false);
  }
  public ScaleIOPersistentVolumeSourceBuilder(ScaleIOPersistentVolumeSourceFluent<?> fluent,ScaleIOPersistentVolumeSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withFsType(instance.getFsType());
      fluent.withGateway(instance.getGateway());
      fluent.withProtectionDomain(instance.getProtectionDomain());
      fluent.withReadOnly(instance.getReadOnly());
      fluent.withSecretRef(instance.getSecretRef());
      fluent.withSslEnabled(instance.getSslEnabled());
      fluent.withStorageMode(instance.getStorageMode());
      fluent.withStoragePool(instance.getStoragePool());
      fluent.withSystem(instance.getSystem());
      fluent.withVolumeName(instance.getVolumeName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ScaleIOPersistentVolumeSourceBuilder(ScaleIOPersistentVolumeSource instance) {
    this(instance,false);
  }
  public ScaleIOPersistentVolumeSourceBuilder(ScaleIOPersistentVolumeSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withFsType(instance.getFsType());
      this.withGateway(instance.getGateway());
      this.withProtectionDomain(instance.getProtectionDomain());
      this.withReadOnly(instance.getReadOnly());
      this.withSecretRef(instance.getSecretRef());
      this.withSslEnabled(instance.getSslEnabled());
      this.withStorageMode(instance.getStorageMode());
      this.withStoragePool(instance.getStoragePool());
      this.withSystem(instance.getSystem());
      this.withVolumeName(instance.getVolumeName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ScaleIOPersistentVolumeSourceFluent<?> fluent;
  Boolean validationEnabled;
  public ScaleIOPersistentVolumeSource build() {
    ScaleIOPersistentVolumeSource buildable = new ScaleIOPersistentVolumeSource(fluent.getFsType(),fluent.getGateway(),fluent.getProtectionDomain(),fluent.getReadOnly(),fluent.getSecretRef(),fluent.getSslEnabled(),fluent.getStorageMode(),fluent.getStoragePool(),fluent.getSystem(),fluent.getVolumeName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}