package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SecretEnvSourceBuilder extends SecretEnvSourceFluentImpl<SecretEnvSourceBuilder> implements VisitableBuilder<SecretEnvSource,SecretEnvSourceBuilder>{
  public SecretEnvSourceBuilder() {
    this(false);
  }
  public SecretEnvSourceBuilder(Boolean validationEnabled) {
    this(new SecretEnvSource(), validationEnabled);
  }
  public SecretEnvSourceBuilder(SecretEnvSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public SecretEnvSourceBuilder(SecretEnvSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SecretEnvSource(), validationEnabled);
  }
  public SecretEnvSourceBuilder(SecretEnvSourceFluent<?> fluent,SecretEnvSource instance) {
    this(fluent, instance, false);
  }
  public SecretEnvSourceBuilder(SecretEnvSourceFluent<?> fluent,SecretEnvSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withOptional(instance.getOptional());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SecretEnvSourceBuilder(SecretEnvSource instance) {
    this(instance,false);
  }
  public SecretEnvSourceBuilder(SecretEnvSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withName(instance.getName());
      this.withOptional(instance.getOptional());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SecretEnvSourceFluent<?> fluent;
  Boolean validationEnabled;
  public SecretEnvSource build() {
    SecretEnvSource buildable = new SecretEnvSource(fluent.getName(),fluent.getOptional());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}