package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SecretProjectionBuilder extends SecretProjectionFluentImpl<SecretProjectionBuilder> implements VisitableBuilder<SecretProjection,SecretProjectionBuilder>{
  public SecretProjectionBuilder() {
    this(false);
  }
  public SecretProjectionBuilder(Boolean validationEnabled) {
    this(new SecretProjection(), validationEnabled);
  }
  public SecretProjectionBuilder(SecretProjectionFluent<?> fluent) {
    this(fluent, false);
  }
  public SecretProjectionBuilder(SecretProjectionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SecretProjection(), validationEnabled);
  }
  public SecretProjectionBuilder(SecretProjectionFluent<?> fluent,SecretProjection instance) {
    this(fluent, instance, false);
  }
  public SecretProjectionBuilder(SecretProjectionFluent<?> fluent,SecretProjection instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withItems(instance.getItems());
      fluent.withName(instance.getName());
      fluent.withOptional(instance.getOptional());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SecretProjectionBuilder(SecretProjection instance) {
    this(instance,false);
  }
  public SecretProjectionBuilder(SecretProjection instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withItems(instance.getItems());
      this.withName(instance.getName());
      this.withOptional(instance.getOptional());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SecretProjectionFluent<?> fluent;
  Boolean validationEnabled;
  public SecretProjection build() {
    SecretProjection buildable = new SecretProjection(fluent.getItems(),fluent.getName(),fluent.getOptional());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}