package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TCPSocketActionBuilder extends TCPSocketActionFluentImpl<TCPSocketActionBuilder> implements VisitableBuilder<TCPSocketAction,TCPSocketActionBuilder>{
  public TCPSocketActionBuilder() {
    this(false);
  }
  public TCPSocketActionBuilder(Boolean validationEnabled) {
    this(new TCPSocketAction(), validationEnabled);
  }
  public TCPSocketActionBuilder(TCPSocketActionFluent<?> fluent) {
    this(fluent, false);
  }
  public TCPSocketActionBuilder(TCPSocketActionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TCPSocketAction(), validationEnabled);
  }
  public TCPSocketActionBuilder(TCPSocketActionFluent<?> fluent,TCPSocketAction instance) {
    this(fluent, instance, false);
  }
  public TCPSocketActionBuilder(TCPSocketActionFluent<?> fluent,TCPSocketAction instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withHost(instance.getHost());
      fluent.withPort(instance.getPort());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TCPSocketActionBuilder(TCPSocketAction instance) {
    this(instance,false);
  }
  public TCPSocketActionBuilder(TCPSocketAction instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withHost(instance.getHost());
      this.withPort(instance.getPort());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  TCPSocketActionFluent<?> fluent;
  Boolean validationEnabled;
  public TCPSocketAction build() {
    TCPSocketAction buildable = new TCPSocketAction(fluent.getHost(),fluent.getPort());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}