package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VolumeNodeAffinityBuilder extends VolumeNodeAffinityFluentImpl<VolumeNodeAffinityBuilder> implements VisitableBuilder<VolumeNodeAffinity,VolumeNodeAffinityBuilder>{
  public VolumeNodeAffinityBuilder() {
    this(false);
  }
  public VolumeNodeAffinityBuilder(Boolean validationEnabled) {
    this(new VolumeNodeAffinity(), validationEnabled);
  }
  public VolumeNodeAffinityBuilder(VolumeNodeAffinityFluent<?> fluent) {
    this(fluent, false);
  }
  public VolumeNodeAffinityBuilder(VolumeNodeAffinityFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new VolumeNodeAffinity(), validationEnabled);
  }
  public VolumeNodeAffinityBuilder(VolumeNodeAffinityFluent<?> fluent,VolumeNodeAffinity instance) {
    this(fluent, instance, false);
  }
  public VolumeNodeAffinityBuilder(VolumeNodeAffinityFluent<?> fluent,VolumeNodeAffinity instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withRequired(instance.getRequired());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public VolumeNodeAffinityBuilder(VolumeNodeAffinity instance) {
    this(instance,false);
  }
  public VolumeNodeAffinityBuilder(VolumeNodeAffinity instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withRequired(instance.getRequired());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  VolumeNodeAffinityFluent<?> fluent;
  Boolean validationEnabled;
  public VolumeNodeAffinity build() {
    VolumeNodeAffinity buildable = new VolumeNodeAffinity(fluent.getRequired());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}