package io.fabric8.kubernetes.api.model;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class AWSElasticBlockStoreVolumeSourceFluent<A extends AWSElasticBlockStoreVolumeSourceFluent<A>> extends BaseFluent<A>{
  public AWSElasticBlockStoreVolumeSourceFluent() {
  }
  public AWSElasticBlockStoreVolumeSourceFluent(AWSElasticBlockStoreVolumeSource instance) {
    instance = (instance != null ? instance : new AWSElasticBlockStoreVolumeSource());

    if (instance != null) {
      this.withFsType(instance.getFsType());
      this.withPartition(instance.getPartition());
      this.withReadOnly(instance.getReadOnly());
      this.withVolumeID(instance.getVolumeID());
      this.withFsType(instance.getFsType());
      this.withPartition(instance.getPartition());
      this.withReadOnly(instance.getReadOnly());
      this.withVolumeID(instance.getVolumeID());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String fsType;
  private Integer partition;
  private Boolean readOnly;
  private String volumeID;
  private Map<String,Object> additionalProperties;
  public String getFsType() {
    return this.fsType;
  }
  public A withFsType(String fsType) {
    this.fsType=fsType; return (A) this;
  }
  public boolean hasFsType() {
    return this.fsType != null;
  }
  public Integer getPartition() {
    return this.partition;
  }
  public A withPartition(Integer partition) {
    this.partition=partition; return (A) this;
  }
  public boolean hasPartition() {
    return this.partition != null;
  }
  public Boolean getReadOnly() {
    return this.readOnly;
  }
  public A withReadOnly(Boolean readOnly) {
    this.readOnly=readOnly; return (A) this;
  }
  public boolean hasReadOnly() {
    return this.readOnly != null;
  }
  public String getVolumeID() {
    return this.volumeID;
  }
  public A withVolumeID(String volumeID) {
    this.volumeID=volumeID; return (A) this;
  }
  public boolean hasVolumeID() {
    return this.volumeID != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AWSElasticBlockStoreVolumeSourceFluent that = (AWSElasticBlockStoreVolumeSourceFluent) o;
    if (!java.util.Objects.equals(fsType, that.fsType)) return false;

    if (!java.util.Objects.equals(partition, that.partition)) return false;

    if (!java.util.Objects.equals(readOnly, that.readOnly)) return false;

    if (!java.util.Objects.equals(volumeID, that.volumeID)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fsType,  partition,  readOnly,  volumeID,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (fsType != null) { sb.append("fsType:"); sb.append(fsType + ","); }
    if (partition != null) { sb.append("partition:"); sb.append(partition + ","); }
    if (readOnly != null) { sb.append("readOnly:"); sb.append(readOnly + ","); }
    if (volumeID != null) { sb.append("volumeID:"); sb.append(volumeID + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withReadOnly() {
    return withReadOnly(true);
  }
  
}