package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ComponentStatusBuilder extends ComponentStatusFluent<ComponentStatusBuilder> implements VisitableBuilder<ComponentStatus,ComponentStatusBuilder>{
  public ComponentStatusBuilder() {
    this(false);
  }
  public ComponentStatusBuilder(Boolean validationEnabled) {
    this(new ComponentStatus(), validationEnabled);
  }
  public ComponentStatusBuilder(ComponentStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ComponentStatusBuilder(ComponentStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ComponentStatus(), validationEnabled);
  }
  public ComponentStatusBuilder(ComponentStatusFluent<?> fluent,ComponentStatus instance) {
    this(fluent, instance, false);
  }
  public ComponentStatusBuilder(ComponentStatusFluent<?> fluent,ComponentStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ComponentStatus());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withConditions(instance.getConditions());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withConditions(instance.getConditions());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ComponentStatusBuilder(ComponentStatus instance) {
    this(instance,false);
  }
  public ComponentStatusBuilder(ComponentStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ComponentStatus());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withConditions(instance.getConditions());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withConditions(instance.getConditions());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ComponentStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ComponentStatus build() {
    ComponentStatus buildable = new ComponentStatus(fluent.getApiVersion(),fluent.buildConditions(),fluent.getKind(),fluent.buildMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}