package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConfigMapBuilder extends ConfigMapFluent<ConfigMapBuilder> implements VisitableBuilder<ConfigMap,ConfigMapBuilder>{
  public ConfigMapBuilder() {
    this(false);
  }
  public ConfigMapBuilder(Boolean validationEnabled) {
    this(new ConfigMap(), validationEnabled);
  }
  public ConfigMapBuilder(ConfigMapFluent<?> fluent) {
    this(fluent, false);
  }
  public ConfigMapBuilder(ConfigMapFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConfigMap(), validationEnabled);
  }
  public ConfigMapBuilder(ConfigMapFluent<?> fluent,ConfigMap instance) {
    this(fluent, instance, false);
  }
  public ConfigMapBuilder(ConfigMapFluent<?> fluent,ConfigMap instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ConfigMap());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withBinaryData(instance.getBinaryData());
      fluent.withData(instance.getData());
      fluent.withImmutable(instance.getImmutable());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withBinaryData(instance.getBinaryData());
      fluent.withData(instance.getData());
      fluent.withImmutable(instance.getImmutable());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConfigMapBuilder(ConfigMap instance) {
    this(instance,false);
  }
  public ConfigMapBuilder(ConfigMap instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ConfigMap());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withBinaryData(instance.getBinaryData());
      this.withData(instance.getData());
      this.withImmutable(instance.getImmutable());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withBinaryData(instance.getBinaryData());
      this.withData(instance.getData());
      this.withImmutable(instance.getImmutable());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConfigMapFluent<?> fluent;
  Boolean validationEnabled;
  public ConfigMap build() {
    ConfigMap buildable = new ConfigMap(fluent.getApiVersion(),fluent.getBinaryData(),fluent.getData(),fluent.getImmutable(),fluent.getKind(),fluent.buildMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}