package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConfigMapListBuilder extends ConfigMapListFluent<ConfigMapListBuilder> implements VisitableBuilder<ConfigMapList,ConfigMapListBuilder>{
  public ConfigMapListBuilder() {
    this(false);
  }
  public ConfigMapListBuilder(Boolean validationEnabled) {
    this(new ConfigMapList(), validationEnabled);
  }
  public ConfigMapListBuilder(ConfigMapListFluent<?> fluent) {
    this(fluent, false);
  }
  public ConfigMapListBuilder(ConfigMapListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConfigMapList(), validationEnabled);
  }
  public ConfigMapListBuilder(ConfigMapListFluent<?> fluent,ConfigMapList instance) {
    this(fluent, instance, false);
  }
  public ConfigMapListBuilder(ConfigMapListFluent<?> fluent,ConfigMapList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ConfigMapList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConfigMapListBuilder(ConfigMapList instance) {
    this(instance,false);
  }
  public ConfigMapListBuilder(ConfigMapList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ConfigMapList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConfigMapListFluent<?> fluent;
  Boolean validationEnabled;
  public ConfigMapList build() {
    ConfigMapList buildable = new ConfigMapList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.buildMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}