package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ContainerResizePolicyBuilder extends ContainerResizePolicyFluent<ContainerResizePolicyBuilder> implements VisitableBuilder<ContainerResizePolicy,ContainerResizePolicyBuilder>{
  public ContainerResizePolicyBuilder() {
    this(false);
  }
  public ContainerResizePolicyBuilder(Boolean validationEnabled) {
    this(new ContainerResizePolicy(), validationEnabled);
  }
  public ContainerResizePolicyBuilder(ContainerResizePolicyFluent<?> fluent) {
    this(fluent, false);
  }
  public ContainerResizePolicyBuilder(ContainerResizePolicyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ContainerResizePolicy(), validationEnabled);
  }
  public ContainerResizePolicyBuilder(ContainerResizePolicyFluent<?> fluent,ContainerResizePolicy instance) {
    this(fluent, instance, false);
  }
  public ContainerResizePolicyBuilder(ContainerResizePolicyFluent<?> fluent,ContainerResizePolicy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ContainerResizePolicy());

    if (instance != null) {
      fluent.withResourceName(instance.getResourceName());
      fluent.withRestartPolicy(instance.getRestartPolicy());
      fluent.withResourceName(instance.getResourceName());
      fluent.withRestartPolicy(instance.getRestartPolicy());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ContainerResizePolicyBuilder(ContainerResizePolicy instance) {
    this(instance,false);
  }
  public ContainerResizePolicyBuilder(ContainerResizePolicy instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ContainerResizePolicy());

    if (instance != null) {
      this.withResourceName(instance.getResourceName());
      this.withRestartPolicy(instance.getRestartPolicy());
      this.withResourceName(instance.getResourceName());
      this.withRestartPolicy(instance.getRestartPolicy());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ContainerResizePolicyFluent<?> fluent;
  Boolean validationEnabled;
  public ContainerResizePolicy build() {
    ContainerResizePolicy buildable = new ContainerResizePolicy(fluent.getResourceName(),fluent.getRestartPolicy());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}