package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ContainerStateRunningBuilder extends ContainerStateRunningFluent<ContainerStateRunningBuilder> implements VisitableBuilder<ContainerStateRunning,ContainerStateRunningBuilder>{
  public ContainerStateRunningBuilder() {
    this(false);
  }
  public ContainerStateRunningBuilder(Boolean validationEnabled) {
    this(new ContainerStateRunning(), validationEnabled);
  }
  public ContainerStateRunningBuilder(ContainerStateRunningFluent<?> fluent) {
    this(fluent, false);
  }
  public ContainerStateRunningBuilder(ContainerStateRunningFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ContainerStateRunning(), validationEnabled);
  }
  public ContainerStateRunningBuilder(ContainerStateRunningFluent<?> fluent,ContainerStateRunning instance) {
    this(fluent, instance, false);
  }
  public ContainerStateRunningBuilder(ContainerStateRunningFluent<?> fluent,ContainerStateRunning instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ContainerStateRunning());

    if (instance != null) {
      fluent.withStartedAt(instance.getStartedAt());
      fluent.withStartedAt(instance.getStartedAt());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ContainerStateRunningBuilder(ContainerStateRunning instance) {
    this(instance,false);
  }
  public ContainerStateRunningBuilder(ContainerStateRunning instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ContainerStateRunning());

    if (instance != null) {
      this.withStartedAt(instance.getStartedAt());
      this.withStartedAt(instance.getStartedAt());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ContainerStateRunningFluent<?> fluent;
  Boolean validationEnabled;
  public ContainerStateRunning build() {
    ContainerStateRunning buildable = new ContainerStateRunning(fluent.getStartedAt());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}