package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class DownwardAPIVolumeFileFluent<A extends DownwardAPIVolumeFileFluent<A>> extends BaseFluent<A>{
  public DownwardAPIVolumeFileFluent() {
  }
  public DownwardAPIVolumeFileFluent(DownwardAPIVolumeFile instance) {
    instance = (instance != null ? instance : new DownwardAPIVolumeFile());

    if (instance != null) {
      this.withFieldRef(instance.getFieldRef());
      this.withMode(instance.getMode());
      this.withPath(instance.getPath());
      this.withResourceFieldRef(instance.getResourceFieldRef());
      this.withFieldRef(instance.getFieldRef());
      this.withMode(instance.getMode());
      this.withPath(instance.getPath());
      this.withResourceFieldRef(instance.getResourceFieldRef());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ObjectFieldSelectorBuilder fieldRef;
  private Integer mode;
  private String path;
  private ResourceFieldSelectorBuilder resourceFieldRef;
  private Map<String,Object> additionalProperties;
  public ObjectFieldSelector buildFieldRef() {
    return this.fieldRef!=null ?this.fieldRef.build():null;
  }
  public A withFieldRef(ObjectFieldSelector fieldRef) {
    _visitables.get("fieldRef").remove(this.fieldRef);
    if (fieldRef!=null){ this.fieldRef= new ObjectFieldSelectorBuilder(fieldRef); _visitables.get("fieldRef").add(this.fieldRef);} else { this.fieldRef = null; _visitables.get("fieldRef").remove(this.fieldRef); } return (A) this;
  }
  public boolean hasFieldRef() {
    return this.fieldRef != null;
  }
  public A withNewFieldRef(String apiVersion,String fieldPath) {
    return (A)withFieldRef(new ObjectFieldSelector(apiVersion, fieldPath));
  }
  public FieldRefNested<A> withNewFieldRef() {
    return new FieldRefNested(null);
  }
  public FieldRefNested<A> withNewFieldRefLike(ObjectFieldSelector item) {
    return new FieldRefNested(item);
  }
  public FieldRefNested<A> editFieldRef() {
    return withNewFieldRefLike(java.util.Optional.ofNullable(buildFieldRef()).orElse(null));
  }
  public FieldRefNested<A> editOrNewFieldRef() {
    return withNewFieldRefLike(java.util.Optional.ofNullable(buildFieldRef()).orElse(new ObjectFieldSelectorBuilder().build()));
  }
  public FieldRefNested<A> editOrNewFieldRefLike(ObjectFieldSelector item) {
    return withNewFieldRefLike(java.util.Optional.ofNullable(buildFieldRef()).orElse(item));
  }
  public Integer getMode() {
    return this.mode;
  }
  public A withMode(Integer mode) {
    this.mode=mode; return (A) this;
  }
  public boolean hasMode() {
    return this.mode != null;
  }
  public String getPath() {
    return this.path;
  }
  public A withPath(String path) {
    this.path=path; return (A) this;
  }
  public boolean hasPath() {
    return this.path != null;
  }
  public ResourceFieldSelector buildResourceFieldRef() {
    return this.resourceFieldRef!=null ?this.resourceFieldRef.build():null;
  }
  public A withResourceFieldRef(ResourceFieldSelector resourceFieldRef) {
    _visitables.get("resourceFieldRef").remove(this.resourceFieldRef);
    if (resourceFieldRef!=null){ this.resourceFieldRef= new ResourceFieldSelectorBuilder(resourceFieldRef); _visitables.get("resourceFieldRef").add(this.resourceFieldRef);} else { this.resourceFieldRef = null; _visitables.get("resourceFieldRef").remove(this.resourceFieldRef); } return (A) this;
  }
  public boolean hasResourceFieldRef() {
    return this.resourceFieldRef != null;
  }
  public ResourceFieldRefNested<A> withNewResourceFieldRef() {
    return new ResourceFieldRefNested(null);
  }
  public ResourceFieldRefNested<A> withNewResourceFieldRefLike(ResourceFieldSelector item) {
    return new ResourceFieldRefNested(item);
  }
  public ResourceFieldRefNested<A> editResourceFieldRef() {
    return withNewResourceFieldRefLike(java.util.Optional.ofNullable(buildResourceFieldRef()).orElse(null));
  }
  public ResourceFieldRefNested<A> editOrNewResourceFieldRef() {
    return withNewResourceFieldRefLike(java.util.Optional.ofNullable(buildResourceFieldRef()).orElse(new ResourceFieldSelectorBuilder().build()));
  }
  public ResourceFieldRefNested<A> editOrNewResourceFieldRefLike(ResourceFieldSelector item) {
    return withNewResourceFieldRefLike(java.util.Optional.ofNullable(buildResourceFieldRef()).orElse(item));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DownwardAPIVolumeFileFluent that = (DownwardAPIVolumeFileFluent) o;
    if (!java.util.Objects.equals(fieldRef, that.fieldRef)) return false;

    if (!java.util.Objects.equals(mode, that.mode)) return false;

    if (!java.util.Objects.equals(path, that.path)) return false;

    if (!java.util.Objects.equals(resourceFieldRef, that.resourceFieldRef)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fieldRef,  mode,  path,  resourceFieldRef,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (fieldRef != null) { sb.append("fieldRef:"); sb.append(fieldRef + ","); }
    if (mode != null) { sb.append("mode:"); sb.append(mode + ","); }
    if (path != null) { sb.append("path:"); sb.append(path + ","); }
    if (resourceFieldRef != null) { sb.append("resourceFieldRef:"); sb.append(resourceFieldRef + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class FieldRefNested<N> extends ObjectFieldSelectorFluent<FieldRefNested<N>> implements Nested<N>{
    FieldRefNested(ObjectFieldSelector item) {
      this.builder = new ObjectFieldSelectorBuilder(this, item);
    }
    ObjectFieldSelectorBuilder builder;
    public N and() {
      return (N) DownwardAPIVolumeFileFluent.this.withFieldRef(builder.build());
    }
    public N endFieldRef() {
      return and();
    }
    
  }
  public class ResourceFieldRefNested<N> extends ResourceFieldSelectorFluent<ResourceFieldRefNested<N>> implements Nested<N>{
    ResourceFieldRefNested(ResourceFieldSelector item) {
      this.builder = new ResourceFieldSelectorBuilder(this, item);
    }
    ResourceFieldSelectorBuilder builder;
    public N and() {
      return (N) DownwardAPIVolumeFileFluent.this.withResourceFieldRef(builder.build());
    }
    public N endResourceFieldRef() {
      return and();
    }
    
  }
  
}