package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DownwardAPIVolumeSourceBuilder extends DownwardAPIVolumeSourceFluent<DownwardAPIVolumeSourceBuilder> implements VisitableBuilder<DownwardAPIVolumeSource,DownwardAPIVolumeSourceBuilder>{
  public DownwardAPIVolumeSourceBuilder() {
    this(false);
  }
  public DownwardAPIVolumeSourceBuilder(Boolean validationEnabled) {
    this(new DownwardAPIVolumeSource(), validationEnabled);
  }
  public DownwardAPIVolumeSourceBuilder(DownwardAPIVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public DownwardAPIVolumeSourceBuilder(DownwardAPIVolumeSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DownwardAPIVolumeSource(), validationEnabled);
  }
  public DownwardAPIVolumeSourceBuilder(DownwardAPIVolumeSourceFluent<?> fluent,DownwardAPIVolumeSource instance) {
    this(fluent, instance, false);
  }
  public DownwardAPIVolumeSourceBuilder(DownwardAPIVolumeSourceFluent<?> fluent,DownwardAPIVolumeSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DownwardAPIVolumeSource());

    if (instance != null) {
      fluent.withDefaultMode(instance.getDefaultMode());
      fluent.withItems(instance.getItems());
      fluent.withDefaultMode(instance.getDefaultMode());
      fluent.withItems(instance.getItems());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DownwardAPIVolumeSourceBuilder(DownwardAPIVolumeSource instance) {
    this(instance,false);
  }
  public DownwardAPIVolumeSourceBuilder(DownwardAPIVolumeSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DownwardAPIVolumeSource());

    if (instance != null) {
      this.withDefaultMode(instance.getDefaultMode());
      this.withItems(instance.getItems());
      this.withDefaultMode(instance.getDefaultMode());
      this.withItems(instance.getItems());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DownwardAPIVolumeSourceFluent<?> fluent;
  Boolean validationEnabled;
  public DownwardAPIVolumeSource build() {
    DownwardAPIVolumeSource buildable = new DownwardAPIVolumeSource(fluent.getDefaultMode(),fluent.buildItems());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}