package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EmptyDirVolumeSourceBuilder extends EmptyDirVolumeSourceFluent<EmptyDirVolumeSourceBuilder> implements VisitableBuilder<EmptyDirVolumeSource,EmptyDirVolumeSourceBuilder>{
  public EmptyDirVolumeSourceBuilder() {
    this(false);
  }
  public EmptyDirVolumeSourceBuilder(Boolean validationEnabled) {
    this(new EmptyDirVolumeSource(), validationEnabled);
  }
  public EmptyDirVolumeSourceBuilder(EmptyDirVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public EmptyDirVolumeSourceBuilder(EmptyDirVolumeSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EmptyDirVolumeSource(), validationEnabled);
  }
  public EmptyDirVolumeSourceBuilder(EmptyDirVolumeSourceFluent<?> fluent,EmptyDirVolumeSource instance) {
    this(fluent, instance, false);
  }
  public EmptyDirVolumeSourceBuilder(EmptyDirVolumeSourceFluent<?> fluent,EmptyDirVolumeSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new EmptyDirVolumeSource());

    if (instance != null) {
      fluent.withMedium(instance.getMedium());
      fluent.withSizeLimit(instance.getSizeLimit());
      fluent.withMedium(instance.getMedium());
      fluent.withSizeLimit(instance.getSizeLimit());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EmptyDirVolumeSourceBuilder(EmptyDirVolumeSource instance) {
    this(instance,false);
  }
  public EmptyDirVolumeSourceBuilder(EmptyDirVolumeSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new EmptyDirVolumeSource());

    if (instance != null) {
      this.withMedium(instance.getMedium());
      this.withSizeLimit(instance.getSizeLimit());
      this.withMedium(instance.getMedium());
      this.withSizeLimit(instance.getSizeLimit());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  EmptyDirVolumeSourceFluent<?> fluent;
  Boolean validationEnabled;
  public EmptyDirVolumeSource build() {
    EmptyDirVolumeSource buildable = new EmptyDirVolumeSource(fluent.getMedium(),fluent.buildSizeLimit());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}