package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class EmptyDirVolumeSourceFluent<A extends EmptyDirVolumeSourceFluent<A>> extends BaseFluent<A>{
  public EmptyDirVolumeSourceFluent() {
  }
  public EmptyDirVolumeSourceFluent(EmptyDirVolumeSource instance) {
    instance = (instance != null ? instance : new EmptyDirVolumeSource());

    if (instance != null) {
      this.withMedium(instance.getMedium());
      this.withSizeLimit(instance.getSizeLimit());
      this.withMedium(instance.getMedium());
      this.withSizeLimit(instance.getSizeLimit());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String medium;
  private QuantityBuilder sizeLimit;
  private Map<String,Object> additionalProperties;
  public String getMedium() {
    return this.medium;
  }
  public A withMedium(String medium) {
    this.medium=medium; return (A) this;
  }
  public boolean hasMedium() {
    return this.medium != null;
  }
  public Quantity buildSizeLimit() {
    return this.sizeLimit!=null ?this.sizeLimit.build():null;
  }
  public A withSizeLimit(Quantity sizeLimit) {
    _visitables.get("sizeLimit").remove(this.sizeLimit);
    if (sizeLimit!=null){ this.sizeLimit= new QuantityBuilder(sizeLimit); _visitables.get("sizeLimit").add(this.sizeLimit);} else { this.sizeLimit = null; _visitables.get("sizeLimit").remove(this.sizeLimit); } return (A) this;
  }
  public boolean hasSizeLimit() {
    return this.sizeLimit != null;
  }
  public A withNewSizeLimit(String amount,String format) {
    return (A)withSizeLimit(new Quantity(amount, format));
  }
  public A withNewSizeLimit(String amount) {
    return (A)withSizeLimit(new Quantity(amount));
  }
  public SizeLimitNested<A> withNewSizeLimit() {
    return new SizeLimitNested(null);
  }
  public SizeLimitNested<A> withNewSizeLimitLike(Quantity item) {
    return new SizeLimitNested(item);
  }
  public SizeLimitNested<A> editSizeLimit() {
    return withNewSizeLimitLike(java.util.Optional.ofNullable(buildSizeLimit()).orElse(null));
  }
  public SizeLimitNested<A> editOrNewSizeLimit() {
    return withNewSizeLimitLike(java.util.Optional.ofNullable(buildSizeLimit()).orElse(new QuantityBuilder().build()));
  }
  public SizeLimitNested<A> editOrNewSizeLimitLike(Quantity item) {
    return withNewSizeLimitLike(java.util.Optional.ofNullable(buildSizeLimit()).orElse(item));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    EmptyDirVolumeSourceFluent that = (EmptyDirVolumeSourceFluent) o;
    if (!java.util.Objects.equals(medium, that.medium)) return false;

    if (!java.util.Objects.equals(sizeLimit, that.sizeLimit)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(medium,  sizeLimit,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (medium != null) { sb.append("medium:"); sb.append(medium + ","); }
    if (sizeLimit != null) { sb.append("sizeLimit:"); sb.append(sizeLimit + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class SizeLimitNested<N> extends QuantityFluent<SizeLimitNested<N>> implements Nested<N>{
    SizeLimitNested(Quantity item) {
      this.builder = new QuantityBuilder(this, item);
    }
    QuantityBuilder builder;
    public N and() {
      return (N) EmptyDirVolumeSourceFluent.this.withSizeLimit(builder.build());
    }
    public N endSizeLimit() {
      return and();
    }
    
  }
  
}