package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class EndpointSubsetFluent<A extends EndpointSubsetFluent<A>> extends BaseFluent<A>{
  public EndpointSubsetFluent() {
  }
  public EndpointSubsetFluent(EndpointSubset instance) {
    instance = (instance != null ? instance : new EndpointSubset());

    if (instance != null) {
      this.withAddresses(instance.getAddresses());
      this.withNotReadyAddresses(instance.getNotReadyAddresses());
      this.withPorts(instance.getPorts());
      this.withAddresses(instance.getAddresses());
      this.withNotReadyAddresses(instance.getNotReadyAddresses());
      this.withPorts(instance.getPorts());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ArrayList<EndpointAddressBuilder> addresses = new ArrayList<EndpointAddressBuilder>();
  private ArrayList<EndpointAddressBuilder> notReadyAddresses = new ArrayList<EndpointAddressBuilder>();
  private ArrayList<EndpointPortBuilder> ports = new ArrayList<EndpointPortBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToAddresses(int index,EndpointAddress item) {
    if (this.addresses == null) {this.addresses = new ArrayList<EndpointAddressBuilder>();}
    EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
    if (index < 0 || index >= addresses.size()) { _visitables.get("addresses").add(builder); addresses.add(builder); } else { _visitables.get("addresses").add(index, builder); addresses.add(index, builder);}
    return (A)this;
  }
  public A setToAddresses(int index,EndpointAddress item) {
    if (this.addresses == null) {this.addresses = new ArrayList<EndpointAddressBuilder>();}
    EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
    if (index < 0 || index >= addresses.size()) { _visitables.get("addresses").add(builder); addresses.add(builder); } else { _visitables.get("addresses").set(index, builder); addresses.set(index, builder);}
    return (A)this;
  }
  public A addToAddresses(io.fabric8.kubernetes.api.model.EndpointAddress... items) {
    if (this.addresses == null) {this.addresses = new ArrayList<EndpointAddressBuilder>();}
    for (EndpointAddress item : items) {EndpointAddressBuilder builder = new EndpointAddressBuilder(item);_visitables.get("addresses").add(builder);this.addresses.add(builder);} return (A)this;
  }
  public A addAllToAddresses(Collection<EndpointAddress> items) {
    if (this.addresses == null) {this.addresses = new ArrayList<EndpointAddressBuilder>();}
    for (EndpointAddress item : items) {EndpointAddressBuilder builder = new EndpointAddressBuilder(item);_visitables.get("addresses").add(builder);this.addresses.add(builder);} return (A)this;
  }
  public A removeFromAddresses(io.fabric8.kubernetes.api.model.EndpointAddress... items) {
    if (this.addresses == null) return (A)this;
    for (EndpointAddress item : items) {EndpointAddressBuilder builder = new EndpointAddressBuilder(item);_visitables.get("addresses").remove(builder); this.addresses.remove(builder);} return (A)this;
  }
  public A removeAllFromAddresses(Collection<EndpointAddress> items) {
    if (this.addresses == null) return (A)this;
    for (EndpointAddress item : items) {EndpointAddressBuilder builder = new EndpointAddressBuilder(item);_visitables.get("addresses").remove(builder); this.addresses.remove(builder);} return (A)this;
  }
  public A removeMatchingFromAddresses(Predicate<EndpointAddressBuilder> predicate) {
    if (addresses == null) return (A) this;
    final Iterator<EndpointAddressBuilder> each = addresses.iterator();
    final List visitables = _visitables.get("addresses");
    while (each.hasNext()) {
      EndpointAddressBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<EndpointAddress> buildAddresses() {
    return addresses != null ? build(addresses) : null;
  }
  public EndpointAddress buildAddress(int index) {
    return this.addresses.get(index).build();
  }
  public EndpointAddress buildFirstAddress() {
    return this.addresses.get(0).build();
  }
  public EndpointAddress buildLastAddress() {
    return this.addresses.get(addresses.size() - 1).build();
  }
  public EndpointAddress buildMatchingAddress(Predicate<EndpointAddressBuilder> predicate) {
    for (EndpointAddressBuilder item: addresses) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingAddress(Predicate<EndpointAddressBuilder> predicate) {
    for (EndpointAddressBuilder item: addresses) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAddresses(List<EndpointAddress> addresses) {
    if (this.addresses != null) { _visitables.get("addresses").clear();}
    if (addresses != null) {this.addresses = new ArrayList(); for (EndpointAddress item : addresses){this.addToAddresses(item);}} else { this.addresses = null;} return (A) this;
  }
  public A withAddresses(io.fabric8.kubernetes.api.model.EndpointAddress... addresses) {
    if (this.addresses != null) {this.addresses.clear(); _visitables.remove("addresses"); }
    if (addresses != null) {for (EndpointAddress item :addresses){ this.addToAddresses(item);}} return (A) this;
  }
  public boolean hasAddresses() {
    return addresses != null && !addresses.isEmpty();
  }
  public AddressesNested<A> addNewAddress() {
    return new AddressesNested(-1, null);
  }
  public AddressesNested<A> addNewAddressLike(EndpointAddress item) {
    return new AddressesNested(-1, item);
  }
  public AddressesNested<A> setNewAddressLike(int index,EndpointAddress item) {
    return new AddressesNested(index, item);
  }
  public AddressesNested<A> editAddress(int index) {
    if (addresses.size() <= index) throw new RuntimeException("Can't edit addresses. Index exceeds size.");
    return setNewAddressLike(index, buildAddress(index));
  }
  public AddressesNested<A> editFirstAddress() {
    if (addresses.size() == 0) throw new RuntimeException("Can't edit first addresses. The list is empty.");
    return setNewAddressLike(0, buildAddress(0));
  }
  public AddressesNested<A> editLastAddress() {
    int index = addresses.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last addresses. The list is empty.");
    return setNewAddressLike(index, buildAddress(index));
  }
  public AddressesNested<A> editMatchingAddress(Predicate<EndpointAddressBuilder> predicate) {
    int index = -1;
    for (int i=0;i<addresses.size();i++) { 
    if (predicate.test(addresses.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching addresses. No match found.");
    return setNewAddressLike(index, buildAddress(index));
  }
  public A addToNotReadyAddresses(int index,EndpointAddress item) {
    if (this.notReadyAddresses == null) {this.notReadyAddresses = new ArrayList<EndpointAddressBuilder>();}
    EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
    if (index < 0 || index >= notReadyAddresses.size()) { _visitables.get("notReadyAddresses").add(builder); notReadyAddresses.add(builder); } else { _visitables.get("notReadyAddresses").add(index, builder); notReadyAddresses.add(index, builder);}
    return (A)this;
  }
  public A setToNotReadyAddresses(int index,EndpointAddress item) {
    if (this.notReadyAddresses == null) {this.notReadyAddresses = new ArrayList<EndpointAddressBuilder>();}
    EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
    if (index < 0 || index >= notReadyAddresses.size()) { _visitables.get("notReadyAddresses").add(builder); notReadyAddresses.add(builder); } else { _visitables.get("notReadyAddresses").set(index, builder); notReadyAddresses.set(index, builder);}
    return (A)this;
  }
  public A addToNotReadyAddresses(io.fabric8.kubernetes.api.model.EndpointAddress... items) {
    if (this.notReadyAddresses == null) {this.notReadyAddresses = new ArrayList<EndpointAddressBuilder>();}
    for (EndpointAddress item : items) {EndpointAddressBuilder builder = new EndpointAddressBuilder(item);_visitables.get("notReadyAddresses").add(builder);this.notReadyAddresses.add(builder);} return (A)this;
  }
  public A addAllToNotReadyAddresses(Collection<EndpointAddress> items) {
    if (this.notReadyAddresses == null) {this.notReadyAddresses = new ArrayList<EndpointAddressBuilder>();}
    for (EndpointAddress item : items) {EndpointAddressBuilder builder = new EndpointAddressBuilder(item);_visitables.get("notReadyAddresses").add(builder);this.notReadyAddresses.add(builder);} return (A)this;
  }
  public A removeFromNotReadyAddresses(io.fabric8.kubernetes.api.model.EndpointAddress... items) {
    if (this.notReadyAddresses == null) return (A)this;
    for (EndpointAddress item : items) {EndpointAddressBuilder builder = new EndpointAddressBuilder(item);_visitables.get("notReadyAddresses").remove(builder); this.notReadyAddresses.remove(builder);} return (A)this;
  }
  public A removeAllFromNotReadyAddresses(Collection<EndpointAddress> items) {
    if (this.notReadyAddresses == null) return (A)this;
    for (EndpointAddress item : items) {EndpointAddressBuilder builder = new EndpointAddressBuilder(item);_visitables.get("notReadyAddresses").remove(builder); this.notReadyAddresses.remove(builder);} return (A)this;
  }
  public A removeMatchingFromNotReadyAddresses(Predicate<EndpointAddressBuilder> predicate) {
    if (notReadyAddresses == null) return (A) this;
    final Iterator<EndpointAddressBuilder> each = notReadyAddresses.iterator();
    final List visitables = _visitables.get("notReadyAddresses");
    while (each.hasNext()) {
      EndpointAddressBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<EndpointAddress> buildNotReadyAddresses() {
    return notReadyAddresses != null ? build(notReadyAddresses) : null;
  }
  public EndpointAddress buildNotReadyAddress(int index) {
    return this.notReadyAddresses.get(index).build();
  }
  public EndpointAddress buildFirstNotReadyAddress() {
    return this.notReadyAddresses.get(0).build();
  }
  public EndpointAddress buildLastNotReadyAddress() {
    return this.notReadyAddresses.get(notReadyAddresses.size() - 1).build();
  }
  public EndpointAddress buildMatchingNotReadyAddress(Predicate<EndpointAddressBuilder> predicate) {
    for (EndpointAddressBuilder item: notReadyAddresses) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingNotReadyAddress(Predicate<EndpointAddressBuilder> predicate) {
    for (EndpointAddressBuilder item: notReadyAddresses) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withNotReadyAddresses(List<EndpointAddress> notReadyAddresses) {
    if (this.notReadyAddresses != null) { _visitables.get("notReadyAddresses").clear();}
    if (notReadyAddresses != null) {this.notReadyAddresses = new ArrayList(); for (EndpointAddress item : notReadyAddresses){this.addToNotReadyAddresses(item);}} else { this.notReadyAddresses = null;} return (A) this;
  }
  public A withNotReadyAddresses(io.fabric8.kubernetes.api.model.EndpointAddress... notReadyAddresses) {
    if (this.notReadyAddresses != null) {this.notReadyAddresses.clear(); _visitables.remove("notReadyAddresses"); }
    if (notReadyAddresses != null) {for (EndpointAddress item :notReadyAddresses){ this.addToNotReadyAddresses(item);}} return (A) this;
  }
  public boolean hasNotReadyAddresses() {
    return notReadyAddresses != null && !notReadyAddresses.isEmpty();
  }
  public NotReadyAddressesNested<A> addNewNotReadyAddress() {
    return new NotReadyAddressesNested(-1, null);
  }
  public NotReadyAddressesNested<A> addNewNotReadyAddressLike(EndpointAddress item) {
    return new NotReadyAddressesNested(-1, item);
  }
  public NotReadyAddressesNested<A> setNewNotReadyAddressLike(int index,EndpointAddress item) {
    return new NotReadyAddressesNested(index, item);
  }
  public NotReadyAddressesNested<A> editNotReadyAddress(int index) {
    if (notReadyAddresses.size() <= index) throw new RuntimeException("Can't edit notReadyAddresses. Index exceeds size.");
    return setNewNotReadyAddressLike(index, buildNotReadyAddress(index));
  }
  public NotReadyAddressesNested<A> editFirstNotReadyAddress() {
    if (notReadyAddresses.size() == 0) throw new RuntimeException("Can't edit first notReadyAddresses. The list is empty.");
    return setNewNotReadyAddressLike(0, buildNotReadyAddress(0));
  }
  public NotReadyAddressesNested<A> editLastNotReadyAddress() {
    int index = notReadyAddresses.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last notReadyAddresses. The list is empty.");
    return setNewNotReadyAddressLike(index, buildNotReadyAddress(index));
  }
  public NotReadyAddressesNested<A> editMatchingNotReadyAddress(Predicate<EndpointAddressBuilder> predicate) {
    int index = -1;
    for (int i=0;i<notReadyAddresses.size();i++) { 
    if (predicate.test(notReadyAddresses.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching notReadyAddresses. No match found.");
    return setNewNotReadyAddressLike(index, buildNotReadyAddress(index));
  }
  public A addToPorts(int index,EndpointPort item) {
    if (this.ports == null) {this.ports = new ArrayList<EndpointPortBuilder>();}
    EndpointPortBuilder builder = new EndpointPortBuilder(item);
    if (index < 0 || index >= ports.size()) { _visitables.get("ports").add(builder); ports.add(builder); } else { _visitables.get("ports").add(index, builder); ports.add(index, builder);}
    return (A)this;
  }
  public A setToPorts(int index,EndpointPort item) {
    if (this.ports == null) {this.ports = new ArrayList<EndpointPortBuilder>();}
    EndpointPortBuilder builder = new EndpointPortBuilder(item);
    if (index < 0 || index >= ports.size()) { _visitables.get("ports").add(builder); ports.add(builder); } else { _visitables.get("ports").set(index, builder); ports.set(index, builder);}
    return (A)this;
  }
  public A addToPorts(io.fabric8.kubernetes.api.model.EndpointPort... items) {
    if (this.ports == null) {this.ports = new ArrayList<EndpointPortBuilder>();}
    for (EndpointPort item : items) {EndpointPortBuilder builder = new EndpointPortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
  }
  public A addAllToPorts(Collection<EndpointPort> items) {
    if (this.ports == null) {this.ports = new ArrayList<EndpointPortBuilder>();}
    for (EndpointPort item : items) {EndpointPortBuilder builder = new EndpointPortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
  }
  public A removeFromPorts(io.fabric8.kubernetes.api.model.EndpointPort... items) {
    if (this.ports == null) return (A)this;
    for (EndpointPort item : items) {EndpointPortBuilder builder = new EndpointPortBuilder(item);_visitables.get("ports").remove(builder); this.ports.remove(builder);} return (A)this;
  }
  public A removeAllFromPorts(Collection<EndpointPort> items) {
    if (this.ports == null) return (A)this;
    for (EndpointPort item : items) {EndpointPortBuilder builder = new EndpointPortBuilder(item);_visitables.get("ports").remove(builder); this.ports.remove(builder);} return (A)this;
  }
  public A removeMatchingFromPorts(Predicate<EndpointPortBuilder> predicate) {
    if (ports == null) return (A) this;
    final Iterator<EndpointPortBuilder> each = ports.iterator();
    final List visitables = _visitables.get("ports");
    while (each.hasNext()) {
      EndpointPortBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<EndpointPort> buildPorts() {
    return ports != null ? build(ports) : null;
  }
  public EndpointPort buildPort(int index) {
    return this.ports.get(index).build();
  }
  public EndpointPort buildFirstPort() {
    return this.ports.get(0).build();
  }
  public EndpointPort buildLastPort() {
    return this.ports.get(ports.size() - 1).build();
  }
  public EndpointPort buildMatchingPort(Predicate<EndpointPortBuilder> predicate) {
    for (EndpointPortBuilder item: ports) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingPort(Predicate<EndpointPortBuilder> predicate) {
    for (EndpointPortBuilder item: ports) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPorts(List<EndpointPort> ports) {
    if (this.ports != null) { _visitables.get("ports").clear();}
    if (ports != null) {this.ports = new ArrayList(); for (EndpointPort item : ports){this.addToPorts(item);}} else { this.ports = null;} return (A) this;
  }
  public A withPorts(io.fabric8.kubernetes.api.model.EndpointPort... ports) {
    if (this.ports != null) {this.ports.clear(); _visitables.remove("ports"); }
    if (ports != null) {for (EndpointPort item :ports){ this.addToPorts(item);}} return (A) this;
  }
  public boolean hasPorts() {
    return ports != null && !ports.isEmpty();
  }
  public A addNewPort(String appProtocol,String name,Integer port,String protocol) {
    return (A)addToPorts(new EndpointPort(appProtocol, name, port, protocol));
  }
  public PortsNested<A> addNewPort() {
    return new PortsNested(-1, null);
  }
  public PortsNested<A> addNewPortLike(EndpointPort item) {
    return new PortsNested(-1, item);
  }
  public PortsNested<A> setNewPortLike(int index,EndpointPort item) {
    return new PortsNested(index, item);
  }
  public PortsNested<A> editPort(int index) {
    if (ports.size() <= index) throw new RuntimeException("Can't edit ports. Index exceeds size.");
    return setNewPortLike(index, buildPort(index));
  }
  public PortsNested<A> editFirstPort() {
    if (ports.size() == 0) throw new RuntimeException("Can't edit first ports. The list is empty.");
    return setNewPortLike(0, buildPort(0));
  }
  public PortsNested<A> editLastPort() {
    int index = ports.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last ports. The list is empty.");
    return setNewPortLike(index, buildPort(index));
  }
  public PortsNested<A> editMatchingPort(Predicate<EndpointPortBuilder> predicate) {
    int index = -1;
    for (int i=0;i<ports.size();i++) { 
    if (predicate.test(ports.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching ports. No match found.");
    return setNewPortLike(index, buildPort(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    EndpointSubsetFluent that = (EndpointSubsetFluent) o;
    if (!java.util.Objects.equals(addresses, that.addresses)) return false;

    if (!java.util.Objects.equals(notReadyAddresses, that.notReadyAddresses)) return false;

    if (!java.util.Objects.equals(ports, that.ports)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(addresses,  notReadyAddresses,  ports,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (addresses != null && !addresses.isEmpty()) { sb.append("addresses:"); sb.append(addresses + ","); }
    if (notReadyAddresses != null && !notReadyAddresses.isEmpty()) { sb.append("notReadyAddresses:"); sb.append(notReadyAddresses + ","); }
    if (ports != null && !ports.isEmpty()) { sb.append("ports:"); sb.append(ports + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class AddressesNested<N> extends EndpointAddressFluent<AddressesNested<N>> implements Nested<N>{
    AddressesNested(int index,EndpointAddress item) {
      this.index = index;
      this.builder = new EndpointAddressBuilder(this, item);
    }
    EndpointAddressBuilder builder;
    int index;
    public N and() {
      return (N) EndpointSubsetFluent.this.setToAddresses(index,builder.build());
    }
    public N endAddress() {
      return and();
    }
    
  }
  public class NotReadyAddressesNested<N> extends EndpointAddressFluent<NotReadyAddressesNested<N>> implements Nested<N>{
    NotReadyAddressesNested(int index,EndpointAddress item) {
      this.index = index;
      this.builder = new EndpointAddressBuilder(this, item);
    }
    EndpointAddressBuilder builder;
    int index;
    public N and() {
      return (N) EndpointSubsetFluent.this.setToNotReadyAddresses(index,builder.build());
    }
    public N endNotReadyAddress() {
      return and();
    }
    
  }
  public class PortsNested<N> extends EndpointPortFluent<PortsNested<N>> implements Nested<N>{
    PortsNested(int index,EndpointPort item) {
      this.index = index;
      this.builder = new EndpointPortBuilder(this, item);
    }
    EndpointPortBuilder builder;
    int index;
    public N and() {
      return (N) EndpointSubsetFluent.this.setToPorts(index,builder.build());
    }
    public N endPort() {
      return and();
    }
    
  }
  
}