package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EnvVarSourceBuilder extends EnvVarSourceFluent<EnvVarSourceBuilder> implements VisitableBuilder<EnvVarSource,EnvVarSourceBuilder>{
  public EnvVarSourceBuilder() {
    this(false);
  }
  public EnvVarSourceBuilder(Boolean validationEnabled) {
    this(new EnvVarSource(), validationEnabled);
  }
  public EnvVarSourceBuilder(EnvVarSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public EnvVarSourceBuilder(EnvVarSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EnvVarSource(), validationEnabled);
  }
  public EnvVarSourceBuilder(EnvVarSourceFluent<?> fluent,EnvVarSource instance) {
    this(fluent, instance, false);
  }
  public EnvVarSourceBuilder(EnvVarSourceFluent<?> fluent,EnvVarSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new EnvVarSource());

    if (instance != null) {
      fluent.withConfigMapKeyRef(instance.getConfigMapKeyRef());
      fluent.withFieldRef(instance.getFieldRef());
      fluent.withResourceFieldRef(instance.getResourceFieldRef());
      fluent.withSecretKeyRef(instance.getSecretKeyRef());
      fluent.withConfigMapKeyRef(instance.getConfigMapKeyRef());
      fluent.withFieldRef(instance.getFieldRef());
      fluent.withResourceFieldRef(instance.getResourceFieldRef());
      fluent.withSecretKeyRef(instance.getSecretKeyRef());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EnvVarSourceBuilder(EnvVarSource instance) {
    this(instance,false);
  }
  public EnvVarSourceBuilder(EnvVarSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new EnvVarSource());

    if (instance != null) {
      this.withConfigMapKeyRef(instance.getConfigMapKeyRef());
      this.withFieldRef(instance.getFieldRef());
      this.withResourceFieldRef(instance.getResourceFieldRef());
      this.withSecretKeyRef(instance.getSecretKeyRef());
      this.withConfigMapKeyRef(instance.getConfigMapKeyRef());
      this.withFieldRef(instance.getFieldRef());
      this.withResourceFieldRef(instance.getResourceFieldRef());
      this.withSecretKeyRef(instance.getSecretKeyRef());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  EnvVarSourceFluent<?> fluent;
  Boolean validationEnabled;
  public EnvVarSource build() {
    EnvVarSource buildable = new EnvVarSource(fluent.buildConfigMapKeyRef(),fluent.buildFieldRef(),fluent.buildResourceFieldRef(),fluent.buildSecretKeyRef());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}