package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KubeSchemaBuilder extends KubeSchemaFluent<KubeSchemaBuilder> implements VisitableBuilder<KubeSchema,KubeSchemaBuilder>{
  public KubeSchemaBuilder() {
    this(false);
  }
  public KubeSchemaBuilder(Boolean validationEnabled) {
    this(new KubeSchema(), validationEnabled);
  }
  public KubeSchemaBuilder(KubeSchemaFluent<?> fluent) {
    this(fluent, false);
  }
  public KubeSchemaBuilder(KubeSchemaFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KubeSchema(), validationEnabled);
  }
  public KubeSchemaBuilder(KubeSchemaFluent<?> fluent,KubeSchema instance) {
    this(fluent, instance, false);
  }
  public KubeSchemaBuilder(KubeSchemaFluent<?> fluent,KubeSchema instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KubeSchema());

    if (instance != null) {
      fluent.withAPIGroup(instance.getAPIGroup());
      fluent.withAPIGroupList(instance.getAPIGroupList());
      fluent.withAPIResource(instance.getAPIResource());
      fluent.withAPIResourceList(instance.getAPIResourceList());
      fluent.withAPIService(instance.getAPIService());
      fluent.withAPIServiceList(instance.getAPIServiceList());
      fluent.withBinding(instance.getBinding());
      fluent.withComponentStatus(instance.getComponentStatus());
      fluent.withComponentStatusList(instance.getComponentStatusList());
      fluent.withCondition(instance.getCondition());
      fluent.withConfig(instance.getConfig());
      fluent.withConfigMap(instance.getConfigMap());
      fluent.withConfigMapList(instance.getConfigMapList());
      fluent.withContainerStatus(instance.getContainerStatus());
      fluent.withCreateOptions(instance.getCreateOptions());
      fluent.withDeleteOptions(instance.getDeleteOptions());
      fluent.withEndpointPort(instance.getEndpointPort());
      fluent.withEndpoints(instance.getEndpoints());
      fluent.withEndpointsList(instance.getEndpointsList());
      fluent.withEnvVar(instance.getEnvVar());
      fluent.withEvent(instance.getEvent());
      fluent.withEventList(instance.getEventList());
      fluent.withEventSeries(instance.getEventSeries());
      fluent.withEventSource(instance.getEventSource());
      fluent.withGetOptions(instance.getGetOptions());
      fluent.withGroupKind(instance.getGroupKind());
      fluent.withGroupVersionKind(instance.getGroupVersionKind());
      fluent.withGroupVersionResource(instance.getGroupVersionResource());
      fluent.withInfo(instance.getInfo());
      fluent.withKubernetesList(instance.getKubernetesList());
      fluent.withLimitRangeList(instance.getLimitRangeList());
      fluent.withListOptions(instance.getListOptions());
      fluent.withMicroTime(instance.getMicroTime());
      fluent.withNamespace(instance.getNamespace());
      fluent.withNamespaceList(instance.getNamespaceList());
      fluent.withNode(instance.getNode());
      fluent.withNodeList(instance.getNodeList());
      fluent.withObjectMeta(instance.getObjectMeta());
      fluent.withPatch(instance.getPatch());
      fluent.withPatchOptions(instance.getPatchOptions());
      fluent.withPersistentVolume(instance.getPersistentVolume());
      fluent.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
      fluent.withPersistentVolumeClaimList(instance.getPersistentVolumeClaimList());
      fluent.withPersistentVolumeList(instance.getPersistentVolumeList());
      fluent.withPodExecOptions(instance.getPodExecOptions());
      fluent.withPodList(instance.getPodList());
      fluent.withPodTemplateList(instance.getPodTemplateList());
      fluent.withQuantity(instance.getQuantity());
      fluent.withReplicationControllerList(instance.getReplicationControllerList());
      fluent.withResourceQuota(instance.getResourceQuota());
      fluent.withResourceQuotaList(instance.getResourceQuotaList());
      fluent.withRootPaths(instance.getRootPaths());
      fluent.withSecret(instance.getSecret());
      fluent.withSecretList(instance.getSecretList());
      fluent.withServiceAccount(instance.getServiceAccount());
      fluent.withServiceAccountList(instance.getServiceAccountList());
      fluent.withServiceList(instance.getServiceList());
      fluent.withStatus(instance.getStatus());
      fluent.withTime(instance.getTime());
      fluent.withToleration(instance.getToleration());
      fluent.withTopologySelectorTerm(instance.getTopologySelectorTerm());
      fluent.withTypeMeta(instance.getTypeMeta());
      fluent.withUpdateOptions(instance.getUpdateOptions());
      fluent.withWatchEvent(instance.getWatchEvent());
      fluent.withAPIGroup(instance.getAPIGroup());
      fluent.withAPIGroupList(instance.getAPIGroupList());
      fluent.withAPIResource(instance.getAPIResource());
      fluent.withAPIResourceList(instance.getAPIResourceList());
      fluent.withAPIService(instance.getAPIService());
      fluent.withAPIServiceList(instance.getAPIServiceList());
      fluent.withBinding(instance.getBinding());
      fluent.withComponentStatus(instance.getComponentStatus());
      fluent.withComponentStatusList(instance.getComponentStatusList());
      fluent.withCondition(instance.getCondition());
      fluent.withConfig(instance.getConfig());
      fluent.withConfigMap(instance.getConfigMap());
      fluent.withConfigMapList(instance.getConfigMapList());
      fluent.withContainerStatus(instance.getContainerStatus());
      fluent.withCreateOptions(instance.getCreateOptions());
      fluent.withDeleteOptions(instance.getDeleteOptions());
      fluent.withEndpointPort(instance.getEndpointPort());
      fluent.withEndpoints(instance.getEndpoints());
      fluent.withEndpointsList(instance.getEndpointsList());
      fluent.withEnvVar(instance.getEnvVar());
      fluent.withEvent(instance.getEvent());
      fluent.withEventList(instance.getEventList());
      fluent.withEventSeries(instance.getEventSeries());
      fluent.withEventSource(instance.getEventSource());
      fluent.withGetOptions(instance.getGetOptions());
      fluent.withGroupKind(instance.getGroupKind());
      fluent.withGroupVersionKind(instance.getGroupVersionKind());
      fluent.withGroupVersionResource(instance.getGroupVersionResource());
      fluent.withInfo(instance.getInfo());
      fluent.withKubernetesList(instance.getKubernetesList());
      fluent.withLimitRangeList(instance.getLimitRangeList());
      fluent.withListOptions(instance.getListOptions());
      fluent.withMicroTime(instance.getMicroTime());
      fluent.withNamespace(instance.getNamespace());
      fluent.withNamespaceList(instance.getNamespaceList());
      fluent.withNode(instance.getNode());
      fluent.withNodeList(instance.getNodeList());
      fluent.withObjectMeta(instance.getObjectMeta());
      fluent.withPatch(instance.getPatch());
      fluent.withPatchOptions(instance.getPatchOptions());
      fluent.withPersistentVolume(instance.getPersistentVolume());
      fluent.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
      fluent.withPersistentVolumeClaimList(instance.getPersistentVolumeClaimList());
      fluent.withPersistentVolumeList(instance.getPersistentVolumeList());
      fluent.withPodExecOptions(instance.getPodExecOptions());
      fluent.withPodList(instance.getPodList());
      fluent.withPodTemplateList(instance.getPodTemplateList());
      fluent.withQuantity(instance.getQuantity());
      fluent.withReplicationControllerList(instance.getReplicationControllerList());
      fluent.withResourceQuota(instance.getResourceQuota());
      fluent.withResourceQuotaList(instance.getResourceQuotaList());
      fluent.withRootPaths(instance.getRootPaths());
      fluent.withSecret(instance.getSecret());
      fluent.withSecretList(instance.getSecretList());
      fluent.withServiceAccount(instance.getServiceAccount());
      fluent.withServiceAccountList(instance.getServiceAccountList());
      fluent.withServiceList(instance.getServiceList());
      fluent.withStatus(instance.getStatus());
      fluent.withTime(instance.getTime());
      fluent.withToleration(instance.getToleration());
      fluent.withTopologySelectorTerm(instance.getTopologySelectorTerm());
      fluent.withTypeMeta(instance.getTypeMeta());
      fluent.withUpdateOptions(instance.getUpdateOptions());
      fluent.withWatchEvent(instance.getWatchEvent());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KubeSchemaBuilder(KubeSchema instance) {
    this(instance,false);
  }
  public KubeSchemaBuilder(KubeSchema instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KubeSchema());

    if (instance != null) {
      this.withAPIGroup(instance.getAPIGroup());
      this.withAPIGroupList(instance.getAPIGroupList());
      this.withAPIResource(instance.getAPIResource());
      this.withAPIResourceList(instance.getAPIResourceList());
      this.withAPIService(instance.getAPIService());
      this.withAPIServiceList(instance.getAPIServiceList());
      this.withBinding(instance.getBinding());
      this.withComponentStatus(instance.getComponentStatus());
      this.withComponentStatusList(instance.getComponentStatusList());
      this.withCondition(instance.getCondition());
      this.withConfig(instance.getConfig());
      this.withConfigMap(instance.getConfigMap());
      this.withConfigMapList(instance.getConfigMapList());
      this.withContainerStatus(instance.getContainerStatus());
      this.withCreateOptions(instance.getCreateOptions());
      this.withDeleteOptions(instance.getDeleteOptions());
      this.withEndpointPort(instance.getEndpointPort());
      this.withEndpoints(instance.getEndpoints());
      this.withEndpointsList(instance.getEndpointsList());
      this.withEnvVar(instance.getEnvVar());
      this.withEvent(instance.getEvent());
      this.withEventList(instance.getEventList());
      this.withEventSeries(instance.getEventSeries());
      this.withEventSource(instance.getEventSource());
      this.withGetOptions(instance.getGetOptions());
      this.withGroupKind(instance.getGroupKind());
      this.withGroupVersionKind(instance.getGroupVersionKind());
      this.withGroupVersionResource(instance.getGroupVersionResource());
      this.withInfo(instance.getInfo());
      this.withKubernetesList(instance.getKubernetesList());
      this.withLimitRangeList(instance.getLimitRangeList());
      this.withListOptions(instance.getListOptions());
      this.withMicroTime(instance.getMicroTime());
      this.withNamespace(instance.getNamespace());
      this.withNamespaceList(instance.getNamespaceList());
      this.withNode(instance.getNode());
      this.withNodeList(instance.getNodeList());
      this.withObjectMeta(instance.getObjectMeta());
      this.withPatch(instance.getPatch());
      this.withPatchOptions(instance.getPatchOptions());
      this.withPersistentVolume(instance.getPersistentVolume());
      this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
      this.withPersistentVolumeClaimList(instance.getPersistentVolumeClaimList());
      this.withPersistentVolumeList(instance.getPersistentVolumeList());
      this.withPodExecOptions(instance.getPodExecOptions());
      this.withPodList(instance.getPodList());
      this.withPodTemplateList(instance.getPodTemplateList());
      this.withQuantity(instance.getQuantity());
      this.withReplicationControllerList(instance.getReplicationControllerList());
      this.withResourceQuota(instance.getResourceQuota());
      this.withResourceQuotaList(instance.getResourceQuotaList());
      this.withRootPaths(instance.getRootPaths());
      this.withSecret(instance.getSecret());
      this.withSecretList(instance.getSecretList());
      this.withServiceAccount(instance.getServiceAccount());
      this.withServiceAccountList(instance.getServiceAccountList());
      this.withServiceList(instance.getServiceList());
      this.withStatus(instance.getStatus());
      this.withTime(instance.getTime());
      this.withToleration(instance.getToleration());
      this.withTopologySelectorTerm(instance.getTopologySelectorTerm());
      this.withTypeMeta(instance.getTypeMeta());
      this.withUpdateOptions(instance.getUpdateOptions());
      this.withWatchEvent(instance.getWatchEvent());
      this.withAPIGroup(instance.getAPIGroup());
      this.withAPIGroupList(instance.getAPIGroupList());
      this.withAPIResource(instance.getAPIResource());
      this.withAPIResourceList(instance.getAPIResourceList());
      this.withAPIService(instance.getAPIService());
      this.withAPIServiceList(instance.getAPIServiceList());
      this.withBinding(instance.getBinding());
      this.withComponentStatus(instance.getComponentStatus());
      this.withComponentStatusList(instance.getComponentStatusList());
      this.withCondition(instance.getCondition());
      this.withConfig(instance.getConfig());
      this.withConfigMap(instance.getConfigMap());
      this.withConfigMapList(instance.getConfigMapList());
      this.withContainerStatus(instance.getContainerStatus());
      this.withCreateOptions(instance.getCreateOptions());
      this.withDeleteOptions(instance.getDeleteOptions());
      this.withEndpointPort(instance.getEndpointPort());
      this.withEndpoints(instance.getEndpoints());
      this.withEndpointsList(instance.getEndpointsList());
      this.withEnvVar(instance.getEnvVar());
      this.withEvent(instance.getEvent());
      this.withEventList(instance.getEventList());
      this.withEventSeries(instance.getEventSeries());
      this.withEventSource(instance.getEventSource());
      this.withGetOptions(instance.getGetOptions());
      this.withGroupKind(instance.getGroupKind());
      this.withGroupVersionKind(instance.getGroupVersionKind());
      this.withGroupVersionResource(instance.getGroupVersionResource());
      this.withInfo(instance.getInfo());
      this.withKubernetesList(instance.getKubernetesList());
      this.withLimitRangeList(instance.getLimitRangeList());
      this.withListOptions(instance.getListOptions());
      this.withMicroTime(instance.getMicroTime());
      this.withNamespace(instance.getNamespace());
      this.withNamespaceList(instance.getNamespaceList());
      this.withNode(instance.getNode());
      this.withNodeList(instance.getNodeList());
      this.withObjectMeta(instance.getObjectMeta());
      this.withPatch(instance.getPatch());
      this.withPatchOptions(instance.getPatchOptions());
      this.withPersistentVolume(instance.getPersistentVolume());
      this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
      this.withPersistentVolumeClaimList(instance.getPersistentVolumeClaimList());
      this.withPersistentVolumeList(instance.getPersistentVolumeList());
      this.withPodExecOptions(instance.getPodExecOptions());
      this.withPodList(instance.getPodList());
      this.withPodTemplateList(instance.getPodTemplateList());
      this.withQuantity(instance.getQuantity());
      this.withReplicationControllerList(instance.getReplicationControllerList());
      this.withResourceQuota(instance.getResourceQuota());
      this.withResourceQuotaList(instance.getResourceQuotaList());
      this.withRootPaths(instance.getRootPaths());
      this.withSecret(instance.getSecret());
      this.withSecretList(instance.getSecretList());
      this.withServiceAccount(instance.getServiceAccount());
      this.withServiceAccountList(instance.getServiceAccountList());
      this.withServiceList(instance.getServiceList());
      this.withStatus(instance.getStatus());
      this.withTime(instance.getTime());
      this.withToleration(instance.getToleration());
      this.withTopologySelectorTerm(instance.getTopologySelectorTerm());
      this.withTypeMeta(instance.getTypeMeta());
      this.withUpdateOptions(instance.getUpdateOptions());
      this.withWatchEvent(instance.getWatchEvent());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  KubeSchemaFluent<?> fluent;
  Boolean validationEnabled;
  public KubeSchema build() {
    KubeSchema buildable = new KubeSchema(fluent.buildAPIGroup(),fluent.buildAPIGroupList(),fluent.buildAPIResource(),fluent.buildAPIResourceList(),fluent.buildAPIService(),fluent.buildAPIServiceList(),fluent.buildBinding(),fluent.buildComponentStatus(),fluent.buildComponentStatusList(),fluent.buildCondition(),fluent.buildConfig(),fluent.buildConfigMap(),fluent.buildConfigMapList(),fluent.buildContainerStatus(),fluent.buildCreateOptions(),fluent.buildDeleteOptions(),fluent.buildEndpointPort(),fluent.buildEndpoints(),fluent.buildEndpointsList(),fluent.buildEnvVar(),fluent.buildEvent(),fluent.buildEventList(),fluent.buildEventSeries(),fluent.buildEventSource(),fluent.buildGetOptions(),fluent.buildGroupKind(),fluent.buildGroupVersionKind(),fluent.buildGroupVersionResource(),fluent.buildInfo(),fluent.buildKubernetesList(),fluent.buildLimitRangeList(),fluent.buildListOptions(),fluent.buildMicroTime(),fluent.buildNamespace(),fluent.buildNamespaceList(),fluent.buildNode(),fluent.buildNodeList(),fluent.buildObjectMeta(),fluent.buildPatch(),fluent.buildPatchOptions(),fluent.buildPersistentVolume(),fluent.buildPersistentVolumeClaim(),fluent.buildPersistentVolumeClaimList(),fluent.buildPersistentVolumeList(),fluent.buildPodExecOptions(),fluent.buildPodList(),fluent.buildPodTemplateList(),fluent.buildQuantity(),fluent.buildReplicationControllerList(),fluent.buildResourceQuota(),fluent.buildResourceQuotaList(),fluent.buildRootPaths(),fluent.buildSecret(),fluent.buildSecretList(),fluent.buildServiceAccount(),fluent.buildServiceAccountList(),fluent.buildServiceList(),fluent.buildStatus(),fluent.getTime(),fluent.buildToleration(),fluent.buildTopologySelectorTerm(),fluent.buildTypeMeta(),fluent.buildUpdateOptions(),fluent.buildWatchEvent());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}