package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KubernetesListBuilder extends KubernetesListFluent<KubernetesListBuilder> implements VisitableBuilder<KubernetesList,KubernetesListBuilder>{
  public KubernetesListBuilder() {
    this(false);
  }
  public KubernetesListBuilder(Boolean validationEnabled) {
    this(new KubernetesList(), validationEnabled);
  }
  public KubernetesListBuilder(KubernetesListFluent<?> fluent) {
    this(fluent, false);
  }
  public KubernetesListBuilder(KubernetesListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KubernetesList(), validationEnabled);
  }
  public KubernetesListBuilder(KubernetesListFluent<?> fluent,KubernetesList instance) {
    this(fluent, instance, false);
  }
  public KubernetesListBuilder(KubernetesListFluent<?> fluent,KubernetesList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KubernetesList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KubernetesListBuilder(KubernetesList instance) {
    this(instance,false);
  }
  public KubernetesListBuilder(KubernetesList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KubernetesList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  KubernetesListFluent<?> fluent;
  Boolean validationEnabled;
  public KubernetesList build() {
    KubernetesList buildable = new KubernetesList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.buildMetadata());
    return buildable;
  }
  
}