package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LimitRangeSpecBuilder extends LimitRangeSpecFluent<LimitRangeSpecBuilder> implements VisitableBuilder<LimitRangeSpec,LimitRangeSpecBuilder>{
  public LimitRangeSpecBuilder() {
    this(false);
  }
  public LimitRangeSpecBuilder(Boolean validationEnabled) {
    this(new LimitRangeSpec(), validationEnabled);
  }
  public LimitRangeSpecBuilder(LimitRangeSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public LimitRangeSpecBuilder(LimitRangeSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new LimitRangeSpec(), validationEnabled);
  }
  public LimitRangeSpecBuilder(LimitRangeSpecFluent<?> fluent,LimitRangeSpec instance) {
    this(fluent, instance, false);
  }
  public LimitRangeSpecBuilder(LimitRangeSpecFluent<?> fluent,LimitRangeSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new LimitRangeSpec());

    if (instance != null) {
      fluent.withLimits(instance.getLimits());
      fluent.withLimits(instance.getLimits());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public LimitRangeSpecBuilder(LimitRangeSpec instance) {
    this(instance,false);
  }
  public LimitRangeSpecBuilder(LimitRangeSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new LimitRangeSpec());

    if (instance != null) {
      this.withLimits(instance.getLimits());
      this.withLimits(instance.getLimits());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  LimitRangeSpecFluent<?> fluent;
  Boolean validationEnabled;
  public LimitRangeSpec build() {
    LimitRangeSpec buildable = new LimitRangeSpec(fluent.buildLimits());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}