package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NodeAffinityBuilder extends NodeAffinityFluent<NodeAffinityBuilder> implements VisitableBuilder<NodeAffinity,NodeAffinityBuilder>{
  public NodeAffinityBuilder() {
    this(false);
  }
  public NodeAffinityBuilder(Boolean validationEnabled) {
    this(new NodeAffinity(), validationEnabled);
  }
  public NodeAffinityBuilder(NodeAffinityFluent<?> fluent) {
    this(fluent, false);
  }
  public NodeAffinityBuilder(NodeAffinityFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NodeAffinity(), validationEnabled);
  }
  public NodeAffinityBuilder(NodeAffinityFluent<?> fluent,NodeAffinity instance) {
    this(fluent, instance, false);
  }
  public NodeAffinityBuilder(NodeAffinityFluent<?> fluent,NodeAffinity instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new NodeAffinity());

    if (instance != null) {
      fluent.withPreferredDuringSchedulingIgnoredDuringExecution(instance.getPreferredDuringSchedulingIgnoredDuringExecution());
      fluent.withRequiredDuringSchedulingIgnoredDuringExecution(instance.getRequiredDuringSchedulingIgnoredDuringExecution());
      fluent.withPreferredDuringSchedulingIgnoredDuringExecution(instance.getPreferredDuringSchedulingIgnoredDuringExecution());
      fluent.withRequiredDuringSchedulingIgnoredDuringExecution(instance.getRequiredDuringSchedulingIgnoredDuringExecution());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NodeAffinityBuilder(NodeAffinity instance) {
    this(instance,false);
  }
  public NodeAffinityBuilder(NodeAffinity instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new NodeAffinity());

    if (instance != null) {
      this.withPreferredDuringSchedulingIgnoredDuringExecution(instance.getPreferredDuringSchedulingIgnoredDuringExecution());
      this.withRequiredDuringSchedulingIgnoredDuringExecution(instance.getRequiredDuringSchedulingIgnoredDuringExecution());
      this.withPreferredDuringSchedulingIgnoredDuringExecution(instance.getPreferredDuringSchedulingIgnoredDuringExecution());
      this.withRequiredDuringSchedulingIgnoredDuringExecution(instance.getRequiredDuringSchedulingIgnoredDuringExecution());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NodeAffinityFluent<?> fluent;
  Boolean validationEnabled;
  public NodeAffinity build() {
    NodeAffinity buildable = new NodeAffinity(fluent.buildPreferredDuringSchedulingIgnoredDuringExecution(),fluent.buildRequiredDuringSchedulingIgnoredDuringExecution());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}