package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NodeBuilder extends NodeFluent<NodeBuilder> implements VisitableBuilder<Node,NodeBuilder>{
  public NodeBuilder() {
    this(false);
  }
  public NodeBuilder(Boolean validationEnabled) {
    this(new Node(), validationEnabled);
  }
  public NodeBuilder(NodeFluent<?> fluent) {
    this(fluent, false);
  }
  public NodeBuilder(NodeFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Node(), validationEnabled);
  }
  public NodeBuilder(NodeFluent<?> fluent,Node instance) {
    this(fluent, instance, false);
  }
  public NodeBuilder(NodeFluent<?> fluent,Node instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Node());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NodeBuilder(Node instance) {
    this(instance,false);
  }
  public NodeBuilder(Node instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Node());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NodeFluent<?> fluent;
  Boolean validationEnabled;
  public Node build() {
    Node buildable = new Node(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}