package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NodeConditionBuilder extends NodeConditionFluent<NodeConditionBuilder> implements VisitableBuilder<NodeCondition,NodeConditionBuilder>{
  public NodeConditionBuilder() {
    this(false);
  }
  public NodeConditionBuilder(Boolean validationEnabled) {
    this(new NodeCondition(), validationEnabled);
  }
  public NodeConditionBuilder(NodeConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public NodeConditionBuilder(NodeConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NodeCondition(), validationEnabled);
  }
  public NodeConditionBuilder(NodeConditionFluent<?> fluent,NodeCondition instance) {
    this(fluent, instance, false);
  }
  public NodeConditionBuilder(NodeConditionFluent<?> fluent,NodeCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new NodeCondition());

    if (instance != null) {
      fluent.withLastHeartbeatTime(instance.getLastHeartbeatTime());
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
      fluent.withLastHeartbeatTime(instance.getLastHeartbeatTime());
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NodeConditionBuilder(NodeCondition instance) {
    this(instance,false);
  }
  public NodeConditionBuilder(NodeCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new NodeCondition());

    if (instance != null) {
      this.withLastHeartbeatTime(instance.getLastHeartbeatTime());
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
      this.withLastHeartbeatTime(instance.getLastHeartbeatTime());
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NodeConditionFluent<?> fluent;
  Boolean validationEnabled;
  public NodeCondition build() {
    NodeCondition buildable = new NodeCondition(fluent.getLastHeartbeatTime(),fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}