package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NodeListBuilder extends NodeListFluent<NodeListBuilder> implements VisitableBuilder<NodeList,NodeListBuilder>{
  public NodeListBuilder() {
    this(false);
  }
  public NodeListBuilder(Boolean validationEnabled) {
    this(new NodeList(), validationEnabled);
  }
  public NodeListBuilder(NodeListFluent<?> fluent) {
    this(fluent, false);
  }
  public NodeListBuilder(NodeListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NodeList(), validationEnabled);
  }
  public NodeListBuilder(NodeListFluent<?> fluent,NodeList instance) {
    this(fluent, instance, false);
  }
  public NodeListBuilder(NodeListFluent<?> fluent,NodeList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new NodeList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NodeListBuilder(NodeList instance) {
    this(instance,false);
  }
  public NodeListBuilder(NodeList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new NodeList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NodeListFluent<?> fluent;
  Boolean validationEnabled;
  public NodeList build() {
    NodeList buildable = new NodeList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.buildMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}