package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class NodeSelectorFluent<A extends NodeSelectorFluent<A>> extends BaseFluent<A>{
  public NodeSelectorFluent() {
  }
  public NodeSelectorFluent(NodeSelector instance) {
    instance = (instance != null ? instance : new NodeSelector());

    if (instance != null) {
      this.withNodeSelectorTerms(instance.getNodeSelectorTerms());
      this.withNodeSelectorTerms(instance.getNodeSelectorTerms());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ArrayList<NodeSelectorTermBuilder> nodeSelectorTerms = new ArrayList<NodeSelectorTermBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToNodeSelectorTerms(int index,NodeSelectorTerm item) {
    if (this.nodeSelectorTerms == null) {this.nodeSelectorTerms = new ArrayList<NodeSelectorTermBuilder>();}
    NodeSelectorTermBuilder builder = new NodeSelectorTermBuilder(item);
    if (index < 0 || index >= nodeSelectorTerms.size()) { _visitables.get("nodeSelectorTerms").add(builder); nodeSelectorTerms.add(builder); } else { _visitables.get("nodeSelectorTerms").add(index, builder); nodeSelectorTerms.add(index, builder);}
    return (A)this;
  }
  public A setToNodeSelectorTerms(int index,NodeSelectorTerm item) {
    if (this.nodeSelectorTerms == null) {this.nodeSelectorTerms = new ArrayList<NodeSelectorTermBuilder>();}
    NodeSelectorTermBuilder builder = new NodeSelectorTermBuilder(item);
    if (index < 0 || index >= nodeSelectorTerms.size()) { _visitables.get("nodeSelectorTerms").add(builder); nodeSelectorTerms.add(builder); } else { _visitables.get("nodeSelectorTerms").set(index, builder); nodeSelectorTerms.set(index, builder);}
    return (A)this;
  }
  public A addToNodeSelectorTerms(io.fabric8.kubernetes.api.model.NodeSelectorTerm... items) {
    if (this.nodeSelectorTerms == null) {this.nodeSelectorTerms = new ArrayList<NodeSelectorTermBuilder>();}
    for (NodeSelectorTerm item : items) {NodeSelectorTermBuilder builder = new NodeSelectorTermBuilder(item);_visitables.get("nodeSelectorTerms").add(builder);this.nodeSelectorTerms.add(builder);} return (A)this;
  }
  public A addAllToNodeSelectorTerms(Collection<NodeSelectorTerm> items) {
    if (this.nodeSelectorTerms == null) {this.nodeSelectorTerms = new ArrayList<NodeSelectorTermBuilder>();}
    for (NodeSelectorTerm item : items) {NodeSelectorTermBuilder builder = new NodeSelectorTermBuilder(item);_visitables.get("nodeSelectorTerms").add(builder);this.nodeSelectorTerms.add(builder);} return (A)this;
  }
  public A removeFromNodeSelectorTerms(io.fabric8.kubernetes.api.model.NodeSelectorTerm... items) {
    if (this.nodeSelectorTerms == null) return (A)this;
    for (NodeSelectorTerm item : items) {NodeSelectorTermBuilder builder = new NodeSelectorTermBuilder(item);_visitables.get("nodeSelectorTerms").remove(builder); this.nodeSelectorTerms.remove(builder);} return (A)this;
  }
  public A removeAllFromNodeSelectorTerms(Collection<NodeSelectorTerm> items) {
    if (this.nodeSelectorTerms == null) return (A)this;
    for (NodeSelectorTerm item : items) {NodeSelectorTermBuilder builder = new NodeSelectorTermBuilder(item);_visitables.get("nodeSelectorTerms").remove(builder); this.nodeSelectorTerms.remove(builder);} return (A)this;
  }
  public A removeMatchingFromNodeSelectorTerms(Predicate<NodeSelectorTermBuilder> predicate) {
    if (nodeSelectorTerms == null) return (A) this;
    final Iterator<NodeSelectorTermBuilder> each = nodeSelectorTerms.iterator();
    final List visitables = _visitables.get("nodeSelectorTerms");
    while (each.hasNext()) {
      NodeSelectorTermBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<NodeSelectorTerm> buildNodeSelectorTerms() {
    return nodeSelectorTerms != null ? build(nodeSelectorTerms) : null;
  }
  public NodeSelectorTerm buildNodeSelectorTerm(int index) {
    return this.nodeSelectorTerms.get(index).build();
  }
  public NodeSelectorTerm buildFirstNodeSelectorTerm() {
    return this.nodeSelectorTerms.get(0).build();
  }
  public NodeSelectorTerm buildLastNodeSelectorTerm() {
    return this.nodeSelectorTerms.get(nodeSelectorTerms.size() - 1).build();
  }
  public NodeSelectorTerm buildMatchingNodeSelectorTerm(Predicate<NodeSelectorTermBuilder> predicate) {
    for (NodeSelectorTermBuilder item: nodeSelectorTerms) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingNodeSelectorTerm(Predicate<NodeSelectorTermBuilder> predicate) {
    for (NodeSelectorTermBuilder item: nodeSelectorTerms) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withNodeSelectorTerms(List<NodeSelectorTerm> nodeSelectorTerms) {
    if (this.nodeSelectorTerms != null) { _visitables.get("nodeSelectorTerms").clear();}
    if (nodeSelectorTerms != null) {this.nodeSelectorTerms = new ArrayList(); for (NodeSelectorTerm item : nodeSelectorTerms){this.addToNodeSelectorTerms(item);}} else { this.nodeSelectorTerms = null;} return (A) this;
  }
  public A withNodeSelectorTerms(io.fabric8.kubernetes.api.model.NodeSelectorTerm... nodeSelectorTerms) {
    if (this.nodeSelectorTerms != null) {this.nodeSelectorTerms.clear(); _visitables.remove("nodeSelectorTerms"); }
    if (nodeSelectorTerms != null) {for (NodeSelectorTerm item :nodeSelectorTerms){ this.addToNodeSelectorTerms(item);}} return (A) this;
  }
  public boolean hasNodeSelectorTerms() {
    return nodeSelectorTerms != null && !nodeSelectorTerms.isEmpty();
  }
  public NodeSelectorTermsNested<A> addNewNodeSelectorTerm() {
    return new NodeSelectorTermsNested(-1, null);
  }
  public NodeSelectorTermsNested<A> addNewNodeSelectorTermLike(NodeSelectorTerm item) {
    return new NodeSelectorTermsNested(-1, item);
  }
  public NodeSelectorTermsNested<A> setNewNodeSelectorTermLike(int index,NodeSelectorTerm item) {
    return new NodeSelectorTermsNested(index, item);
  }
  public NodeSelectorTermsNested<A> editNodeSelectorTerm(int index) {
    if (nodeSelectorTerms.size() <= index) throw new RuntimeException("Can't edit nodeSelectorTerms. Index exceeds size.");
    return setNewNodeSelectorTermLike(index, buildNodeSelectorTerm(index));
  }
  public NodeSelectorTermsNested<A> editFirstNodeSelectorTerm() {
    if (nodeSelectorTerms.size() == 0) throw new RuntimeException("Can't edit first nodeSelectorTerms. The list is empty.");
    return setNewNodeSelectorTermLike(0, buildNodeSelectorTerm(0));
  }
  public NodeSelectorTermsNested<A> editLastNodeSelectorTerm() {
    int index = nodeSelectorTerms.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last nodeSelectorTerms. The list is empty.");
    return setNewNodeSelectorTermLike(index, buildNodeSelectorTerm(index));
  }
  public NodeSelectorTermsNested<A> editMatchingNodeSelectorTerm(Predicate<NodeSelectorTermBuilder> predicate) {
    int index = -1;
    for (int i=0;i<nodeSelectorTerms.size();i++) { 
    if (predicate.test(nodeSelectorTerms.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching nodeSelectorTerms. No match found.");
    return setNewNodeSelectorTermLike(index, buildNodeSelectorTerm(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NodeSelectorFluent that = (NodeSelectorFluent) o;
    if (!java.util.Objects.equals(nodeSelectorTerms, that.nodeSelectorTerms)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(nodeSelectorTerms,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (nodeSelectorTerms != null && !nodeSelectorTerms.isEmpty()) { sb.append("nodeSelectorTerms:"); sb.append(nodeSelectorTerms + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class NodeSelectorTermsNested<N> extends NodeSelectorTermFluent<NodeSelectorTermsNested<N>> implements Nested<N>{
    NodeSelectorTermsNested(int index,NodeSelectorTerm item) {
      this.index = index;
      this.builder = new NodeSelectorTermBuilder(this, item);
    }
    NodeSelectorTermBuilder builder;
    int index;
    public N and() {
      return (N) NodeSelectorFluent.this.setToNodeSelectorTerms(index,builder.build());
    }
    public N endNodeSelectorTerm() {
      return and();
    }
    
  }
  
}