package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NodeStatusBuilder extends NodeStatusFluent<NodeStatusBuilder> implements VisitableBuilder<NodeStatus,NodeStatusBuilder>{
  public NodeStatusBuilder() {
    this(false);
  }
  public NodeStatusBuilder(Boolean validationEnabled) {
    this(new NodeStatus(), validationEnabled);
  }
  public NodeStatusBuilder(NodeStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public NodeStatusBuilder(NodeStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NodeStatus(), validationEnabled);
  }
  public NodeStatusBuilder(NodeStatusFluent<?> fluent,NodeStatus instance) {
    this(fluent, instance, false);
  }
  public NodeStatusBuilder(NodeStatusFluent<?> fluent,NodeStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new NodeStatus());

    if (instance != null) {
      fluent.withAddresses(instance.getAddresses());
      fluent.withAllocatable(instance.getAllocatable());
      fluent.withCapacity(instance.getCapacity());
      fluent.withConditions(instance.getConditions());
      fluent.withConfig(instance.getConfig());
      fluent.withDaemonEndpoints(instance.getDaemonEndpoints());
      fluent.withImages(instance.getImages());
      fluent.withNodeInfo(instance.getNodeInfo());
      fluent.withPhase(instance.getPhase());
      fluent.withVolumesAttached(instance.getVolumesAttached());
      fluent.withVolumesInUse(instance.getVolumesInUse());
      fluent.withAddresses(instance.getAddresses());
      fluent.withAllocatable(instance.getAllocatable());
      fluent.withCapacity(instance.getCapacity());
      fluent.withConditions(instance.getConditions());
      fluent.withConfig(instance.getConfig());
      fluent.withDaemonEndpoints(instance.getDaemonEndpoints());
      fluent.withImages(instance.getImages());
      fluent.withNodeInfo(instance.getNodeInfo());
      fluent.withPhase(instance.getPhase());
      fluent.withVolumesAttached(instance.getVolumesAttached());
      fluent.withVolumesInUse(instance.getVolumesInUse());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NodeStatusBuilder(NodeStatus instance) {
    this(instance,false);
  }
  public NodeStatusBuilder(NodeStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new NodeStatus());

    if (instance != null) {
      this.withAddresses(instance.getAddresses());
      this.withAllocatable(instance.getAllocatable());
      this.withCapacity(instance.getCapacity());
      this.withConditions(instance.getConditions());
      this.withConfig(instance.getConfig());
      this.withDaemonEndpoints(instance.getDaemonEndpoints());
      this.withImages(instance.getImages());
      this.withNodeInfo(instance.getNodeInfo());
      this.withPhase(instance.getPhase());
      this.withVolumesAttached(instance.getVolumesAttached());
      this.withVolumesInUse(instance.getVolumesInUse());
      this.withAddresses(instance.getAddresses());
      this.withAllocatable(instance.getAllocatable());
      this.withCapacity(instance.getCapacity());
      this.withConditions(instance.getConditions());
      this.withConfig(instance.getConfig());
      this.withDaemonEndpoints(instance.getDaemonEndpoints());
      this.withImages(instance.getImages());
      this.withNodeInfo(instance.getNodeInfo());
      this.withPhase(instance.getPhase());
      this.withVolumesAttached(instance.getVolumesAttached());
      this.withVolumesInUse(instance.getVolumesInUse());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NodeStatusFluent<?> fluent;
  Boolean validationEnabled;
  public NodeStatus build() {
    NodeStatus buildable = new NodeStatus(fluent.buildAddresses(),fluent.getAllocatable(),fluent.getCapacity(),fluent.buildConditions(),fluent.buildConfig(),fluent.buildDaemonEndpoints(),fluent.buildImages(),fluent.buildNodeInfo(),fluent.getPhase(),fluent.buildVolumesAttached(),fluent.getVolumesInUse());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}