package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PatchBuilder extends PatchFluent<PatchBuilder> implements VisitableBuilder<Patch,PatchBuilder>{
  public PatchBuilder() {
    this(false);
  }
  public PatchBuilder(Boolean validationEnabled) {
    this(new Patch(), validationEnabled);
  }
  public PatchBuilder(PatchFluent<?> fluent) {
    this(fluent, false);
  }
  public PatchBuilder(PatchFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Patch(), validationEnabled);
  }
  public PatchBuilder(PatchFluent<?> fluent,Patch instance) {
    this(fluent, instance, false);
  }
  public PatchBuilder(PatchFluent<?> fluent,Patch instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Patch());

    if (instance != null) {
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PatchBuilder(Patch instance) {
    this(instance,false);
  }
  public PatchBuilder(Patch instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Patch());

    if (instance != null) {
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PatchFluent<?> fluent;
  Boolean validationEnabled;
  public Patch build() {
    Patch buildable = new Patch();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}