package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PersistentVolumeSpecBuilder extends PersistentVolumeSpecFluent<PersistentVolumeSpecBuilder> implements VisitableBuilder<PersistentVolumeSpec,PersistentVolumeSpecBuilder>{
  public PersistentVolumeSpecBuilder() {
    this(false);
  }
  public PersistentVolumeSpecBuilder(Boolean validationEnabled) {
    this(new PersistentVolumeSpec(), validationEnabled);
  }
  public PersistentVolumeSpecBuilder(PersistentVolumeSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public PersistentVolumeSpecBuilder(PersistentVolumeSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PersistentVolumeSpec(), validationEnabled);
  }
  public PersistentVolumeSpecBuilder(PersistentVolumeSpecFluent<?> fluent,PersistentVolumeSpec instance) {
    this(fluent, instance, false);
  }
  public PersistentVolumeSpecBuilder(PersistentVolumeSpecFluent<?> fluent,PersistentVolumeSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PersistentVolumeSpec());

    if (instance != null) {
      fluent.withAccessModes(instance.getAccessModes());
      fluent.withAwsElasticBlockStore(instance.getAwsElasticBlockStore());
      fluent.withAzureDisk(instance.getAzureDisk());
      fluent.withAzureFile(instance.getAzureFile());
      fluent.withCapacity(instance.getCapacity());
      fluent.withCephfs(instance.getCephfs());
      fluent.withCinder(instance.getCinder());
      fluent.withClaimRef(instance.getClaimRef());
      fluent.withCsi(instance.getCsi());
      fluent.withFc(instance.getFc());
      fluent.withFlexVolume(instance.getFlexVolume());
      fluent.withFlocker(instance.getFlocker());
      fluent.withGcePersistentDisk(instance.getGcePersistentDisk());
      fluent.withGlusterfs(instance.getGlusterfs());
      fluent.withHostPath(instance.getHostPath());
      fluent.withIscsi(instance.getIscsi());
      fluent.withLocal(instance.getLocal());
      fluent.withMountOptions(instance.getMountOptions());
      fluent.withNfs(instance.getNfs());
      fluent.withNodeAffinity(instance.getNodeAffinity());
      fluent.withPersistentVolumeReclaimPolicy(instance.getPersistentVolumeReclaimPolicy());
      fluent.withPhotonPersistentDisk(instance.getPhotonPersistentDisk());
      fluent.withPortworxVolume(instance.getPortworxVolume());
      fluent.withQuobyte(instance.getQuobyte());
      fluent.withRbd(instance.getRbd());
      fluent.withScaleIO(instance.getScaleIO());
      fluent.withStorageClassName(instance.getStorageClassName());
      fluent.withStorageos(instance.getStorageos());
      fluent.withVolumeMode(instance.getVolumeMode());
      fluent.withVsphereVolume(instance.getVsphereVolume());
      fluent.withAccessModes(instance.getAccessModes());
      fluent.withAwsElasticBlockStore(instance.getAwsElasticBlockStore());
      fluent.withAzureDisk(instance.getAzureDisk());
      fluent.withAzureFile(instance.getAzureFile());
      fluent.withCapacity(instance.getCapacity());
      fluent.withCephfs(instance.getCephfs());
      fluent.withCinder(instance.getCinder());
      fluent.withClaimRef(instance.getClaimRef());
      fluent.withCsi(instance.getCsi());
      fluent.withFc(instance.getFc());
      fluent.withFlexVolume(instance.getFlexVolume());
      fluent.withFlocker(instance.getFlocker());
      fluent.withGcePersistentDisk(instance.getGcePersistentDisk());
      fluent.withGlusterfs(instance.getGlusterfs());
      fluent.withHostPath(instance.getHostPath());
      fluent.withIscsi(instance.getIscsi());
      fluent.withLocal(instance.getLocal());
      fluent.withMountOptions(instance.getMountOptions());
      fluent.withNfs(instance.getNfs());
      fluent.withNodeAffinity(instance.getNodeAffinity());
      fluent.withPersistentVolumeReclaimPolicy(instance.getPersistentVolumeReclaimPolicy());
      fluent.withPhotonPersistentDisk(instance.getPhotonPersistentDisk());
      fluent.withPortworxVolume(instance.getPortworxVolume());
      fluent.withQuobyte(instance.getQuobyte());
      fluent.withRbd(instance.getRbd());
      fluent.withScaleIO(instance.getScaleIO());
      fluent.withStorageClassName(instance.getStorageClassName());
      fluent.withStorageos(instance.getStorageos());
      fluent.withVolumeMode(instance.getVolumeMode());
      fluent.withVsphereVolume(instance.getVsphereVolume());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PersistentVolumeSpecBuilder(PersistentVolumeSpec instance) {
    this(instance,false);
  }
  public PersistentVolumeSpecBuilder(PersistentVolumeSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PersistentVolumeSpec());

    if (instance != null) {
      this.withAccessModes(instance.getAccessModes());
      this.withAwsElasticBlockStore(instance.getAwsElasticBlockStore());
      this.withAzureDisk(instance.getAzureDisk());
      this.withAzureFile(instance.getAzureFile());
      this.withCapacity(instance.getCapacity());
      this.withCephfs(instance.getCephfs());
      this.withCinder(instance.getCinder());
      this.withClaimRef(instance.getClaimRef());
      this.withCsi(instance.getCsi());
      this.withFc(instance.getFc());
      this.withFlexVolume(instance.getFlexVolume());
      this.withFlocker(instance.getFlocker());
      this.withGcePersistentDisk(instance.getGcePersistentDisk());
      this.withGlusterfs(instance.getGlusterfs());
      this.withHostPath(instance.getHostPath());
      this.withIscsi(instance.getIscsi());
      this.withLocal(instance.getLocal());
      this.withMountOptions(instance.getMountOptions());
      this.withNfs(instance.getNfs());
      this.withNodeAffinity(instance.getNodeAffinity());
      this.withPersistentVolumeReclaimPolicy(instance.getPersistentVolumeReclaimPolicy());
      this.withPhotonPersistentDisk(instance.getPhotonPersistentDisk());
      this.withPortworxVolume(instance.getPortworxVolume());
      this.withQuobyte(instance.getQuobyte());
      this.withRbd(instance.getRbd());
      this.withScaleIO(instance.getScaleIO());
      this.withStorageClassName(instance.getStorageClassName());
      this.withStorageos(instance.getStorageos());
      this.withVolumeMode(instance.getVolumeMode());
      this.withVsphereVolume(instance.getVsphereVolume());
      this.withAccessModes(instance.getAccessModes());
      this.withAwsElasticBlockStore(instance.getAwsElasticBlockStore());
      this.withAzureDisk(instance.getAzureDisk());
      this.withAzureFile(instance.getAzureFile());
      this.withCapacity(instance.getCapacity());
      this.withCephfs(instance.getCephfs());
      this.withCinder(instance.getCinder());
      this.withClaimRef(instance.getClaimRef());
      this.withCsi(instance.getCsi());
      this.withFc(instance.getFc());
      this.withFlexVolume(instance.getFlexVolume());
      this.withFlocker(instance.getFlocker());
      this.withGcePersistentDisk(instance.getGcePersistentDisk());
      this.withGlusterfs(instance.getGlusterfs());
      this.withHostPath(instance.getHostPath());
      this.withIscsi(instance.getIscsi());
      this.withLocal(instance.getLocal());
      this.withMountOptions(instance.getMountOptions());
      this.withNfs(instance.getNfs());
      this.withNodeAffinity(instance.getNodeAffinity());
      this.withPersistentVolumeReclaimPolicy(instance.getPersistentVolumeReclaimPolicy());
      this.withPhotonPersistentDisk(instance.getPhotonPersistentDisk());
      this.withPortworxVolume(instance.getPortworxVolume());
      this.withQuobyte(instance.getQuobyte());
      this.withRbd(instance.getRbd());
      this.withScaleIO(instance.getScaleIO());
      this.withStorageClassName(instance.getStorageClassName());
      this.withStorageos(instance.getStorageos());
      this.withVolumeMode(instance.getVolumeMode());
      this.withVsphereVolume(instance.getVsphereVolume());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PersistentVolumeSpecFluent<?> fluent;
  Boolean validationEnabled;
  public PersistentVolumeSpec build() {
    PersistentVolumeSpec buildable = new PersistentVolumeSpec(fluent.getAccessModes(),fluent.buildAwsElasticBlockStore(),fluent.buildAzureDisk(),fluent.buildAzureFile(),fluent.getCapacity(),fluent.buildCephfs(),fluent.buildCinder(),fluent.buildClaimRef(),fluent.buildCsi(),fluent.buildFc(),fluent.buildFlexVolume(),fluent.buildFlocker(),fluent.buildGcePersistentDisk(),fluent.buildGlusterfs(),fluent.buildHostPath(),fluent.buildIscsi(),fluent.buildLocal(),fluent.getMountOptions(),fluent.buildNfs(),fluent.buildNodeAffinity(),fluent.getPersistentVolumeReclaimPolicy(),fluent.buildPhotonPersistentDisk(),fluent.buildPortworxVolume(),fluent.buildQuobyte(),fluent.buildRbd(),fluent.buildScaleIO(),fluent.getStorageClassName(),fluent.buildStorageos(),fluent.getVolumeMode(),fluent.buildVsphereVolume());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}