package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodReadinessGateBuilder extends PodReadinessGateFluent<PodReadinessGateBuilder> implements VisitableBuilder<PodReadinessGate,PodReadinessGateBuilder>{
  public PodReadinessGateBuilder() {
    this(false);
  }
  public PodReadinessGateBuilder(Boolean validationEnabled) {
    this(new PodReadinessGate(), validationEnabled);
  }
  public PodReadinessGateBuilder(PodReadinessGateFluent<?> fluent) {
    this(fluent, false);
  }
  public PodReadinessGateBuilder(PodReadinessGateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodReadinessGate(), validationEnabled);
  }
  public PodReadinessGateBuilder(PodReadinessGateFluent<?> fluent,PodReadinessGate instance) {
    this(fluent, instance, false);
  }
  public PodReadinessGateBuilder(PodReadinessGateFluent<?> fluent,PodReadinessGate instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PodReadinessGate());

    if (instance != null) {
      fluent.withConditionType(instance.getConditionType());
      fluent.withConditionType(instance.getConditionType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodReadinessGateBuilder(PodReadinessGate instance) {
    this(instance,false);
  }
  public PodReadinessGateBuilder(PodReadinessGate instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PodReadinessGate());

    if (instance != null) {
      this.withConditionType(instance.getConditionType());
      this.withConditionType(instance.getConditionType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodReadinessGateFluent<?> fluent;
  Boolean validationEnabled;
  public PodReadinessGate build() {
    PodReadinessGate buildable = new PodReadinessGate(fluent.getConditionType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}