package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodSecurityContextBuilder extends PodSecurityContextFluent<PodSecurityContextBuilder> implements VisitableBuilder<PodSecurityContext,PodSecurityContextBuilder>{
  public PodSecurityContextBuilder() {
    this(false);
  }
  public PodSecurityContextBuilder(Boolean validationEnabled) {
    this(new PodSecurityContext(), validationEnabled);
  }
  public PodSecurityContextBuilder(PodSecurityContextFluent<?> fluent) {
    this(fluent, false);
  }
  public PodSecurityContextBuilder(PodSecurityContextFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodSecurityContext(), validationEnabled);
  }
  public PodSecurityContextBuilder(PodSecurityContextFluent<?> fluent,PodSecurityContext instance) {
    this(fluent, instance, false);
  }
  public PodSecurityContextBuilder(PodSecurityContextFluent<?> fluent,PodSecurityContext instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PodSecurityContext());

    if (instance != null) {
      fluent.withFsGroup(instance.getFsGroup());
      fluent.withFsGroupChangePolicy(instance.getFsGroupChangePolicy());
      fluent.withRunAsGroup(instance.getRunAsGroup());
      fluent.withRunAsNonRoot(instance.getRunAsNonRoot());
      fluent.withRunAsUser(instance.getRunAsUser());
      fluent.withSeLinuxOptions(instance.getSeLinuxOptions());
      fluent.withSeccompProfile(instance.getSeccompProfile());
      fluent.withSupplementalGroups(instance.getSupplementalGroups());
      fluent.withSysctls(instance.getSysctls());
      fluent.withWindowsOptions(instance.getWindowsOptions());
      fluent.withFsGroup(instance.getFsGroup());
      fluent.withFsGroupChangePolicy(instance.getFsGroupChangePolicy());
      fluent.withRunAsGroup(instance.getRunAsGroup());
      fluent.withRunAsNonRoot(instance.getRunAsNonRoot());
      fluent.withRunAsUser(instance.getRunAsUser());
      fluent.withSeLinuxOptions(instance.getSeLinuxOptions());
      fluent.withSeccompProfile(instance.getSeccompProfile());
      fluent.withSupplementalGroups(instance.getSupplementalGroups());
      fluent.withSysctls(instance.getSysctls());
      fluent.withWindowsOptions(instance.getWindowsOptions());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodSecurityContextBuilder(PodSecurityContext instance) {
    this(instance,false);
  }
  public PodSecurityContextBuilder(PodSecurityContext instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PodSecurityContext());

    if (instance != null) {
      this.withFsGroup(instance.getFsGroup());
      this.withFsGroupChangePolicy(instance.getFsGroupChangePolicy());
      this.withRunAsGroup(instance.getRunAsGroup());
      this.withRunAsNonRoot(instance.getRunAsNonRoot());
      this.withRunAsUser(instance.getRunAsUser());
      this.withSeLinuxOptions(instance.getSeLinuxOptions());
      this.withSeccompProfile(instance.getSeccompProfile());
      this.withSupplementalGroups(instance.getSupplementalGroups());
      this.withSysctls(instance.getSysctls());
      this.withWindowsOptions(instance.getWindowsOptions());
      this.withFsGroup(instance.getFsGroup());
      this.withFsGroupChangePolicy(instance.getFsGroupChangePolicy());
      this.withRunAsGroup(instance.getRunAsGroup());
      this.withRunAsNonRoot(instance.getRunAsNonRoot());
      this.withRunAsUser(instance.getRunAsUser());
      this.withSeLinuxOptions(instance.getSeLinuxOptions());
      this.withSeccompProfile(instance.getSeccompProfile());
      this.withSupplementalGroups(instance.getSupplementalGroups());
      this.withSysctls(instance.getSysctls());
      this.withWindowsOptions(instance.getWindowsOptions());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodSecurityContextFluent<?> fluent;
  Boolean validationEnabled;
  public PodSecurityContext build() {
    PodSecurityContext buildable = new PodSecurityContext(fluent.getFsGroup(),fluent.getFsGroupChangePolicy(),fluent.getRunAsGroup(),fluent.getRunAsNonRoot(),fluent.getRunAsUser(),fluent.buildSeLinuxOptions(),fluent.buildSeccompProfile(),fluent.getSupplementalGroups(),fluent.buildSysctls(),fluent.buildWindowsOptions());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}