package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodStatusBuilder extends PodStatusFluent<PodStatusBuilder> implements VisitableBuilder<PodStatus,PodStatusBuilder>{
  public PodStatusBuilder() {
    this(false);
  }
  public PodStatusBuilder(Boolean validationEnabled) {
    this(new PodStatus(), validationEnabled);
  }
  public PodStatusBuilder(PodStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public PodStatusBuilder(PodStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodStatus(), validationEnabled);
  }
  public PodStatusBuilder(PodStatusFluent<?> fluent,PodStatus instance) {
    this(fluent, instance, false);
  }
  public PodStatusBuilder(PodStatusFluent<?> fluent,PodStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PodStatus());

    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withContainerStatuses(instance.getContainerStatuses());
      fluent.withEphemeralContainerStatuses(instance.getEphemeralContainerStatuses());
      fluent.withHostIP(instance.getHostIP());
      fluent.withInitContainerStatuses(instance.getInitContainerStatuses());
      fluent.withMessage(instance.getMessage());
      fluent.withNominatedNodeName(instance.getNominatedNodeName());
      fluent.withPhase(instance.getPhase());
      fluent.withPodIP(instance.getPodIP());
      fluent.withPodIPs(instance.getPodIPs());
      fluent.withQosClass(instance.getQosClass());
      fluent.withReason(instance.getReason());
      fluent.withResize(instance.getResize());
      fluent.withStartTime(instance.getStartTime());
      fluent.withConditions(instance.getConditions());
      fluent.withContainerStatuses(instance.getContainerStatuses());
      fluent.withEphemeralContainerStatuses(instance.getEphemeralContainerStatuses());
      fluent.withHostIP(instance.getHostIP());
      fluent.withInitContainerStatuses(instance.getInitContainerStatuses());
      fluent.withMessage(instance.getMessage());
      fluent.withNominatedNodeName(instance.getNominatedNodeName());
      fluent.withPhase(instance.getPhase());
      fluent.withPodIP(instance.getPodIP());
      fluent.withPodIPs(instance.getPodIPs());
      fluent.withQosClass(instance.getQosClass());
      fluent.withReason(instance.getReason());
      fluent.withResize(instance.getResize());
      fluent.withStartTime(instance.getStartTime());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodStatusBuilder(PodStatus instance) {
    this(instance,false);
  }
  public PodStatusBuilder(PodStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PodStatus());

    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withContainerStatuses(instance.getContainerStatuses());
      this.withEphemeralContainerStatuses(instance.getEphemeralContainerStatuses());
      this.withHostIP(instance.getHostIP());
      this.withInitContainerStatuses(instance.getInitContainerStatuses());
      this.withMessage(instance.getMessage());
      this.withNominatedNodeName(instance.getNominatedNodeName());
      this.withPhase(instance.getPhase());
      this.withPodIP(instance.getPodIP());
      this.withPodIPs(instance.getPodIPs());
      this.withQosClass(instance.getQosClass());
      this.withReason(instance.getReason());
      this.withResize(instance.getResize());
      this.withStartTime(instance.getStartTime());
      this.withConditions(instance.getConditions());
      this.withContainerStatuses(instance.getContainerStatuses());
      this.withEphemeralContainerStatuses(instance.getEphemeralContainerStatuses());
      this.withHostIP(instance.getHostIP());
      this.withInitContainerStatuses(instance.getInitContainerStatuses());
      this.withMessage(instance.getMessage());
      this.withNominatedNodeName(instance.getNominatedNodeName());
      this.withPhase(instance.getPhase());
      this.withPodIP(instance.getPodIP());
      this.withPodIPs(instance.getPodIPs());
      this.withQosClass(instance.getQosClass());
      this.withReason(instance.getReason());
      this.withResize(instance.getResize());
      this.withStartTime(instance.getStartTime());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodStatusFluent<?> fluent;
  Boolean validationEnabled;
  public PodStatus build() {
    PodStatus buildable = new PodStatus(fluent.buildConditions(),fluent.buildContainerStatuses(),fluent.buildEphemeralContainerStatuses(),fluent.getHostIP(),fluent.buildInitContainerStatuses(),fluent.getMessage(),fluent.getNominatedNodeName(),fluent.getPhase(),fluent.getPodIP(),fluent.buildPodIPs(),fluent.getQosClass(),fluent.getReason(),fluent.getResize(),fluent.getStartTime());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}