package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodTemplateSpecBuilder extends PodTemplateSpecFluent<PodTemplateSpecBuilder> implements VisitableBuilder<PodTemplateSpec,PodTemplateSpecBuilder>{
  public PodTemplateSpecBuilder() {
    this(false);
  }
  public PodTemplateSpecBuilder(Boolean validationEnabled) {
    this(new PodTemplateSpec(), validationEnabled);
  }
  public PodTemplateSpecBuilder(PodTemplateSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public PodTemplateSpecBuilder(PodTemplateSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodTemplateSpec(), validationEnabled);
  }
  public PodTemplateSpecBuilder(PodTemplateSpecFluent<?> fluent,PodTemplateSpec instance) {
    this(fluent, instance, false);
  }
  public PodTemplateSpecBuilder(PodTemplateSpecFluent<?> fluent,PodTemplateSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PodTemplateSpec());

    if (instance != null) {
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodTemplateSpecBuilder(PodTemplateSpec instance) {
    this(instance,false);
  }
  public PodTemplateSpecBuilder(PodTemplateSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PodTemplateSpec());

    if (instance != null) {
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodTemplateSpecFluent<?> fluent;
  Boolean validationEnabled;
  public PodTemplateSpec build() {
    PodTemplateSpec buildable = new PodTemplateSpec(fluent.buildMetadata(),fluent.buildSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}