package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RootPathsBuilder extends RootPathsFluent<RootPathsBuilder> implements VisitableBuilder<RootPaths,RootPathsBuilder>{
  public RootPathsBuilder() {
    this(false);
  }
  public RootPathsBuilder(Boolean validationEnabled) {
    this(new RootPaths(), validationEnabled);
  }
  public RootPathsBuilder(RootPathsFluent<?> fluent) {
    this(fluent, false);
  }
  public RootPathsBuilder(RootPathsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RootPaths(), validationEnabled);
  }
  public RootPathsBuilder(RootPathsFluent<?> fluent,RootPaths instance) {
    this(fluent, instance, false);
  }
  public RootPathsBuilder(RootPathsFluent<?> fluent,RootPaths instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new RootPaths());

    if (instance != null) {
      fluent.withPaths(instance.getPaths());
      fluent.withPaths(instance.getPaths());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RootPathsBuilder(RootPaths instance) {
    this(instance,false);
  }
  public RootPathsBuilder(RootPaths instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new RootPaths());

    if (instance != null) {
      this.withPaths(instance.getPaths());
      this.withPaths(instance.getPaths());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  RootPathsFluent<?> fluent;
  Boolean validationEnabled;
  public RootPaths build() {
    RootPaths buildable = new RootPaths(fluent.getPaths());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}