package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SELinuxOptionsBuilder extends SELinuxOptionsFluent<SELinuxOptionsBuilder> implements VisitableBuilder<SELinuxOptions,SELinuxOptionsBuilder>{
  public SELinuxOptionsBuilder() {
    this(false);
  }
  public SELinuxOptionsBuilder(Boolean validationEnabled) {
    this(new SELinuxOptions(), validationEnabled);
  }
  public SELinuxOptionsBuilder(SELinuxOptionsFluent<?> fluent) {
    this(fluent, false);
  }
  public SELinuxOptionsBuilder(SELinuxOptionsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SELinuxOptions(), validationEnabled);
  }
  public SELinuxOptionsBuilder(SELinuxOptionsFluent<?> fluent,SELinuxOptions instance) {
    this(fluent, instance, false);
  }
  public SELinuxOptionsBuilder(SELinuxOptionsFluent<?> fluent,SELinuxOptions instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SELinuxOptions());

    if (instance != null) {
      fluent.withLevel(instance.getLevel());
      fluent.withRole(instance.getRole());
      fluent.withType(instance.getType());
      fluent.withUser(instance.getUser());
      fluent.withLevel(instance.getLevel());
      fluent.withRole(instance.getRole());
      fluent.withType(instance.getType());
      fluent.withUser(instance.getUser());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SELinuxOptionsBuilder(SELinuxOptions instance) {
    this(instance,false);
  }
  public SELinuxOptionsBuilder(SELinuxOptions instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SELinuxOptions());

    if (instance != null) {
      this.withLevel(instance.getLevel());
      this.withRole(instance.getRole());
      this.withType(instance.getType());
      this.withUser(instance.getUser());
      this.withLevel(instance.getLevel());
      this.withRole(instance.getRole());
      this.withType(instance.getType());
      this.withUser(instance.getUser());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SELinuxOptionsFluent<?> fluent;
  Boolean validationEnabled;
  public SELinuxOptions build() {
    SELinuxOptions buildable = new SELinuxOptions(fluent.getLevel(),fluent.getRole(),fluent.getType(),fluent.getUser());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}