package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SecretBuilder extends SecretFluent<SecretBuilder> implements VisitableBuilder<Secret,SecretBuilder>{
  public SecretBuilder() {
    this(false);
  }
  public SecretBuilder(Boolean validationEnabled) {
    this(new Secret(), validationEnabled);
  }
  public SecretBuilder(SecretFluent<?> fluent) {
    this(fluent, false);
  }
  public SecretBuilder(SecretFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Secret(), validationEnabled);
  }
  public SecretBuilder(SecretFluent<?> fluent,Secret instance) {
    this(fluent, instance, false);
  }
  public SecretBuilder(SecretFluent<?> fluent,Secret instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Secret());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withData(instance.getData());
      fluent.withImmutable(instance.getImmutable());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withStringData(instance.getStringData());
      fluent.withType(instance.getType());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withData(instance.getData());
      fluent.withImmutable(instance.getImmutable());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withStringData(instance.getStringData());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SecretBuilder(Secret instance) {
    this(instance,false);
  }
  public SecretBuilder(Secret instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Secret());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withData(instance.getData());
      this.withImmutable(instance.getImmutable());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withStringData(instance.getStringData());
      this.withType(instance.getType());
      this.withApiVersion(instance.getApiVersion());
      this.withData(instance.getData());
      this.withImmutable(instance.getImmutable());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withStringData(instance.getStringData());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SecretFluent<?> fluent;
  Boolean validationEnabled;
  public Secret build() {
    Secret buildable = new Secret(fluent.getApiVersion(),fluent.getData(),fluent.getImmutable(),fluent.getKind(),fluent.buildMetadata(),fluent.getStringData(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}