package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SecurityContextBuilder extends SecurityContextFluent<SecurityContextBuilder> implements VisitableBuilder<SecurityContext,SecurityContextBuilder>{
  public SecurityContextBuilder() {
    this(false);
  }
  public SecurityContextBuilder(Boolean validationEnabled) {
    this(new SecurityContext(), validationEnabled);
  }
  public SecurityContextBuilder(SecurityContextFluent<?> fluent) {
    this(fluent, false);
  }
  public SecurityContextBuilder(SecurityContextFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SecurityContext(), validationEnabled);
  }
  public SecurityContextBuilder(SecurityContextFluent<?> fluent,SecurityContext instance) {
    this(fluent, instance, false);
  }
  public SecurityContextBuilder(SecurityContextFluent<?> fluent,SecurityContext instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SecurityContext());

    if (instance != null) {
      fluent.withAllowPrivilegeEscalation(instance.getAllowPrivilegeEscalation());
      fluent.withCapabilities(instance.getCapabilities());
      fluent.withPrivileged(instance.getPrivileged());
      fluent.withProcMount(instance.getProcMount());
      fluent.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem());
      fluent.withRunAsGroup(instance.getRunAsGroup());
      fluent.withRunAsNonRoot(instance.getRunAsNonRoot());
      fluent.withRunAsUser(instance.getRunAsUser());
      fluent.withSeLinuxOptions(instance.getSeLinuxOptions());
      fluent.withSeccompProfile(instance.getSeccompProfile());
      fluent.withWindowsOptions(instance.getWindowsOptions());
      fluent.withAllowPrivilegeEscalation(instance.getAllowPrivilegeEscalation());
      fluent.withCapabilities(instance.getCapabilities());
      fluent.withPrivileged(instance.getPrivileged());
      fluent.withProcMount(instance.getProcMount());
      fluent.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem());
      fluent.withRunAsGroup(instance.getRunAsGroup());
      fluent.withRunAsNonRoot(instance.getRunAsNonRoot());
      fluent.withRunAsUser(instance.getRunAsUser());
      fluent.withSeLinuxOptions(instance.getSeLinuxOptions());
      fluent.withSeccompProfile(instance.getSeccompProfile());
      fluent.withWindowsOptions(instance.getWindowsOptions());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SecurityContextBuilder(SecurityContext instance) {
    this(instance,false);
  }
  public SecurityContextBuilder(SecurityContext instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SecurityContext());

    if (instance != null) {
      this.withAllowPrivilegeEscalation(instance.getAllowPrivilegeEscalation());
      this.withCapabilities(instance.getCapabilities());
      this.withPrivileged(instance.getPrivileged());
      this.withProcMount(instance.getProcMount());
      this.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem());
      this.withRunAsGroup(instance.getRunAsGroup());
      this.withRunAsNonRoot(instance.getRunAsNonRoot());
      this.withRunAsUser(instance.getRunAsUser());
      this.withSeLinuxOptions(instance.getSeLinuxOptions());
      this.withSeccompProfile(instance.getSeccompProfile());
      this.withWindowsOptions(instance.getWindowsOptions());
      this.withAllowPrivilegeEscalation(instance.getAllowPrivilegeEscalation());
      this.withCapabilities(instance.getCapabilities());
      this.withPrivileged(instance.getPrivileged());
      this.withProcMount(instance.getProcMount());
      this.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem());
      this.withRunAsGroup(instance.getRunAsGroup());
      this.withRunAsNonRoot(instance.getRunAsNonRoot());
      this.withRunAsUser(instance.getRunAsUser());
      this.withSeLinuxOptions(instance.getSeLinuxOptions());
      this.withSeccompProfile(instance.getSeccompProfile());
      this.withWindowsOptions(instance.getWindowsOptions());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SecurityContextFluent<?> fluent;
  Boolean validationEnabled;
  public SecurityContext build() {
    SecurityContext buildable = new SecurityContext(fluent.getAllowPrivilegeEscalation(),fluent.buildCapabilities(),fluent.getPrivileged(),fluent.getProcMount(),fluent.getReadOnlyRootFilesystem(),fluent.getRunAsGroup(),fluent.getRunAsNonRoot(),fluent.getRunAsUser(),fluent.buildSeLinuxOptions(),fluent.buildSeccompProfile(),fluent.buildWindowsOptions());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}