package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceAccountListBuilder extends ServiceAccountListFluent<ServiceAccountListBuilder> implements VisitableBuilder<ServiceAccountList,ServiceAccountListBuilder>{
  public ServiceAccountListBuilder() {
    this(false);
  }
  public ServiceAccountListBuilder(Boolean validationEnabled) {
    this(new ServiceAccountList(), validationEnabled);
  }
  public ServiceAccountListBuilder(ServiceAccountListFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceAccountListBuilder(ServiceAccountListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceAccountList(), validationEnabled);
  }
  public ServiceAccountListBuilder(ServiceAccountListFluent<?> fluent,ServiceAccountList instance) {
    this(fluent, instance, false);
  }
  public ServiceAccountListBuilder(ServiceAccountListFluent<?> fluent,ServiceAccountList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ServiceAccountList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServiceAccountListBuilder(ServiceAccountList instance) {
    this(instance,false);
  }
  public ServiceAccountListBuilder(ServiceAccountList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ServiceAccountList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServiceAccountListFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceAccountList build() {
    ServiceAccountList buildable = new ServiceAccountList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.buildMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}