package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceStatusBuilder extends ServiceStatusFluent<ServiceStatusBuilder> implements VisitableBuilder<ServiceStatus,ServiceStatusBuilder>{
  public ServiceStatusBuilder() {
    this(false);
  }
  public ServiceStatusBuilder(Boolean validationEnabled) {
    this(new ServiceStatus(), validationEnabled);
  }
  public ServiceStatusBuilder(ServiceStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceStatusBuilder(ServiceStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceStatus(), validationEnabled);
  }
  public ServiceStatusBuilder(ServiceStatusFluent<?> fluent,ServiceStatus instance) {
    this(fluent, instance, false);
  }
  public ServiceStatusBuilder(ServiceStatusFluent<?> fluent,ServiceStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ServiceStatus());

    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withLoadBalancer(instance.getLoadBalancer());
      fluent.withConditions(instance.getConditions());
      fluent.withLoadBalancer(instance.getLoadBalancer());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServiceStatusBuilder(ServiceStatus instance) {
    this(instance,false);
  }
  public ServiceStatusBuilder(ServiceStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ServiceStatus());

    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withLoadBalancer(instance.getLoadBalancer());
      this.withConditions(instance.getConditions());
      this.withLoadBalancer(instance.getLoadBalancer());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServiceStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceStatus build() {
    ServiceStatus buildable = new ServiceStatus(fluent.buildConditions(),fluent.buildLoadBalancer());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}