package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StorageOSVolumeSourceBuilder extends StorageOSVolumeSourceFluent<StorageOSVolumeSourceBuilder> implements VisitableBuilder<StorageOSVolumeSource,StorageOSVolumeSourceBuilder>{
  public StorageOSVolumeSourceBuilder() {
    this(false);
  }
  public StorageOSVolumeSourceBuilder(Boolean validationEnabled) {
    this(new StorageOSVolumeSource(), validationEnabled);
  }
  public StorageOSVolumeSourceBuilder(StorageOSVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public StorageOSVolumeSourceBuilder(StorageOSVolumeSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StorageOSVolumeSource(), validationEnabled);
  }
  public StorageOSVolumeSourceBuilder(StorageOSVolumeSourceFluent<?> fluent,StorageOSVolumeSource instance) {
    this(fluent, instance, false);
  }
  public StorageOSVolumeSourceBuilder(StorageOSVolumeSourceFluent<?> fluent,StorageOSVolumeSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new StorageOSVolumeSource());

    if (instance != null) {
      fluent.withFsType(instance.getFsType());
      fluent.withReadOnly(instance.getReadOnly());
      fluent.withSecretRef(instance.getSecretRef());
      fluent.withVolumeName(instance.getVolumeName());
      fluent.withVolumeNamespace(instance.getVolumeNamespace());
      fluent.withFsType(instance.getFsType());
      fluent.withReadOnly(instance.getReadOnly());
      fluent.withSecretRef(instance.getSecretRef());
      fluent.withVolumeName(instance.getVolumeName());
      fluent.withVolumeNamespace(instance.getVolumeNamespace());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public StorageOSVolumeSourceBuilder(StorageOSVolumeSource instance) {
    this(instance,false);
  }
  public StorageOSVolumeSourceBuilder(StorageOSVolumeSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new StorageOSVolumeSource());

    if (instance != null) {
      this.withFsType(instance.getFsType());
      this.withReadOnly(instance.getReadOnly());
      this.withSecretRef(instance.getSecretRef());
      this.withVolumeName(instance.getVolumeName());
      this.withVolumeNamespace(instance.getVolumeNamespace());
      this.withFsType(instance.getFsType());
      this.withReadOnly(instance.getReadOnly());
      this.withSecretRef(instance.getSecretRef());
      this.withVolumeName(instance.getVolumeName());
      this.withVolumeNamespace(instance.getVolumeNamespace());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  StorageOSVolumeSourceFluent<?> fluent;
  Boolean validationEnabled;
  public StorageOSVolumeSource build() {
    StorageOSVolumeSource buildable = new StorageOSVolumeSource(fluent.getFsType(),fluent.getReadOnly(),fluent.buildSecretRef(),fluent.getVolumeName(),fluent.getVolumeNamespace());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}