package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TopologySelectorTermBuilder extends TopologySelectorTermFluent<TopologySelectorTermBuilder> implements VisitableBuilder<TopologySelectorTerm,TopologySelectorTermBuilder>{
  public TopologySelectorTermBuilder() {
    this(false);
  }
  public TopologySelectorTermBuilder(Boolean validationEnabled) {
    this(new TopologySelectorTerm(), validationEnabled);
  }
  public TopologySelectorTermBuilder(TopologySelectorTermFluent<?> fluent) {
    this(fluent, false);
  }
  public TopologySelectorTermBuilder(TopologySelectorTermFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TopologySelectorTerm(), validationEnabled);
  }
  public TopologySelectorTermBuilder(TopologySelectorTermFluent<?> fluent,TopologySelectorTerm instance) {
    this(fluent, instance, false);
  }
  public TopologySelectorTermBuilder(TopologySelectorTermFluent<?> fluent,TopologySelectorTerm instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new TopologySelectorTerm());

    if (instance != null) {
      fluent.withMatchLabelExpressions(instance.getMatchLabelExpressions());
      fluent.withMatchLabelExpressions(instance.getMatchLabelExpressions());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TopologySelectorTermBuilder(TopologySelectorTerm instance) {
    this(instance,false);
  }
  public TopologySelectorTermBuilder(TopologySelectorTerm instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new TopologySelectorTerm());

    if (instance != null) {
      this.withMatchLabelExpressions(instance.getMatchLabelExpressions());
      this.withMatchLabelExpressions(instance.getMatchLabelExpressions());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  TopologySelectorTermFluent<?> fluent;
  Boolean validationEnabled;
  public TopologySelectorTerm build() {
    TopologySelectorTerm buildable = new TopologySelectorTerm(fluent.buildMatchLabelExpressions());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}