package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TypeMetaBuilder extends TypeMetaFluent<TypeMetaBuilder> implements VisitableBuilder<TypeMeta,TypeMetaBuilder>{
  public TypeMetaBuilder() {
    this(false);
  }
  public TypeMetaBuilder(Boolean validationEnabled) {
    this(new TypeMeta(), validationEnabled);
  }
  public TypeMetaBuilder(TypeMetaFluent<?> fluent) {
    this(fluent, false);
  }
  public TypeMetaBuilder(TypeMetaFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TypeMeta(), validationEnabled);
  }
  public TypeMetaBuilder(TypeMetaFluent<?> fluent,TypeMeta instance) {
    this(fluent, instance, false);
  }
  public TypeMetaBuilder(TypeMetaFluent<?> fluent,TypeMeta instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new TypeMeta());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TypeMetaBuilder(TypeMeta instance) {
    this(instance,false);
  }
  public TypeMetaBuilder(TypeMeta instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new TypeMeta());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  TypeMetaFluent<?> fluent;
  Boolean validationEnabled;
  public TypeMeta build() {
    TypeMeta buildable = new TypeMeta(fluent.getApiVersion(),fluent.getKind());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}