package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TypedLocalObjectReferenceBuilder extends TypedLocalObjectReferenceFluent<TypedLocalObjectReferenceBuilder> implements VisitableBuilder<TypedLocalObjectReference,TypedLocalObjectReferenceBuilder>{
  public TypedLocalObjectReferenceBuilder() {
    this(false);
  }
  public TypedLocalObjectReferenceBuilder(Boolean validationEnabled) {
    this(new TypedLocalObjectReference(), validationEnabled);
  }
  public TypedLocalObjectReferenceBuilder(TypedLocalObjectReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public TypedLocalObjectReferenceBuilder(TypedLocalObjectReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TypedLocalObjectReference(), validationEnabled);
  }
  public TypedLocalObjectReferenceBuilder(TypedLocalObjectReferenceFluent<?> fluent,TypedLocalObjectReference instance) {
    this(fluent, instance, false);
  }
  public TypedLocalObjectReferenceBuilder(TypedLocalObjectReferenceFluent<?> fluent,TypedLocalObjectReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new TypedLocalObjectReference());

    if (instance != null) {
      fluent.withApiGroup(instance.getApiGroup());
      fluent.withKind(instance.getKind());
      fluent.withName(instance.getName());
      fluent.withApiGroup(instance.getApiGroup());
      fluent.withKind(instance.getKind());
      fluent.withName(instance.getName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TypedLocalObjectReferenceBuilder(TypedLocalObjectReference instance) {
    this(instance,false);
  }
  public TypedLocalObjectReferenceBuilder(TypedLocalObjectReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new TypedLocalObjectReference());

    if (instance != null) {
      this.withApiGroup(instance.getApiGroup());
      this.withKind(instance.getKind());
      this.withName(instance.getName());
      this.withApiGroup(instance.getApiGroup());
      this.withKind(instance.getKind());
      this.withName(instance.getName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  TypedLocalObjectReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public TypedLocalObjectReference build() {
    TypedLocalObjectReference buildable = new TypedLocalObjectReference(fluent.getApiGroup(),fluent.getKind(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}