package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VolumeDeviceBuilder extends VolumeDeviceFluent<VolumeDeviceBuilder> implements VisitableBuilder<VolumeDevice,VolumeDeviceBuilder>{
  public VolumeDeviceBuilder() {
    this(false);
  }
  public VolumeDeviceBuilder(Boolean validationEnabled) {
    this(new VolumeDevice(), validationEnabled);
  }
  public VolumeDeviceBuilder(VolumeDeviceFluent<?> fluent) {
    this(fluent, false);
  }
  public VolumeDeviceBuilder(VolumeDeviceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new VolumeDevice(), validationEnabled);
  }
  public VolumeDeviceBuilder(VolumeDeviceFluent<?> fluent,VolumeDevice instance) {
    this(fluent, instance, false);
  }
  public VolumeDeviceBuilder(VolumeDeviceFluent<?> fluent,VolumeDevice instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new VolumeDevice());

    if (instance != null) {
      fluent.withDevicePath(instance.getDevicePath());
      fluent.withName(instance.getName());
      fluent.withDevicePath(instance.getDevicePath());
      fluent.withName(instance.getName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public VolumeDeviceBuilder(VolumeDevice instance) {
    this(instance,false);
  }
  public VolumeDeviceBuilder(VolumeDevice instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new VolumeDevice());

    if (instance != null) {
      this.withDevicePath(instance.getDevicePath());
      this.withName(instance.getName());
      this.withDevicePath(instance.getDevicePath());
      this.withName(instance.getName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  VolumeDeviceFluent<?> fluent;
  Boolean validationEnabled;
  public VolumeDevice build() {
    VolumeDevice buildable = new VolumeDevice(fluent.getDevicePath(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}