package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class WatchEventBuilder extends WatchEventFluent<WatchEventBuilder> implements VisitableBuilder<WatchEvent,WatchEventBuilder>{
  public WatchEventBuilder() {
    this(false);
  }
  public WatchEventBuilder(Boolean validationEnabled) {
    this(new WatchEvent(), validationEnabled);
  }
  public WatchEventBuilder(WatchEventFluent<?> fluent) {
    this(fluent, false);
  }
  public WatchEventBuilder(WatchEventFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new WatchEvent(), validationEnabled);
  }
  public WatchEventBuilder(WatchEventFluent<?> fluent,WatchEvent instance) {
    this(fluent, instance, false);
  }
  public WatchEventBuilder(WatchEventFluent<?> fluent,WatchEvent instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new WatchEvent());

    if (instance != null) {
      fluent.withObject(instance.getObject());
      fluent.withType(instance.getType());
      fluent.withObject(instance.getObject());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public WatchEventBuilder(WatchEvent instance) {
    this(instance,false);
  }
  public WatchEventBuilder(WatchEvent instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new WatchEvent());

    if (instance != null) {
      this.withObject(instance.getObject());
      this.withType(instance.getType());
      this.withObject(instance.getObject());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  WatchEventFluent<?> fluent;
  Boolean validationEnabled;
  public WatchEvent build() {
    WatchEvent buildable = new WatchEvent(fluent.buildObject(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}