/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.APIService;
import io.fabric8.kubernetes.api.model.APIServiceFluent;

public class APIServiceBuilder
extends APIServiceFluent<APIServiceBuilder>
implements VisitableBuilder<APIService, APIServiceBuilder> {
    APIServiceFluent<?> fluent;
    Boolean validationEnabled;

    public APIServiceBuilder() {
        this(false);
    }

    public APIServiceBuilder(Boolean validationEnabled) {
        this(new APIService(), validationEnabled);
    }

    public APIServiceBuilder(APIServiceFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public APIServiceBuilder(APIServiceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new APIService(), validationEnabled);
    }

    public APIServiceBuilder(APIServiceFluent<?> fluent, APIService instance) {
        this(fluent, instance, false);
    }

    public APIServiceBuilder(APIServiceFluent<?> fluent, APIService instance, Boolean validationEnabled) {
        this.fluent = fluent;
        APIService aPIService = instance = instance != null ? instance : new APIService();
        if (instance != null) {
            fluent.withApiVersion(instance.getApiVersion());
            fluent.withKind(instance.getKind());
            fluent.withMetadata(instance.getMetadata());
            fluent.withSpec(instance.getSpec());
            fluent.withStatus(instance.getStatus());
            fluent.withApiVersion(instance.getApiVersion());
            fluent.withKind(instance.getKind());
            fluent.withMetadata(instance.getMetadata());
            fluent.withSpec(instance.getSpec());
            fluent.withStatus(instance.getStatus());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public APIServiceBuilder(APIService instance) {
        this(instance, (Boolean)false);
    }

    public APIServiceBuilder(APIService instance, Boolean validationEnabled) {
        this.fluent = this;
        APIService aPIService = instance = instance != null ? instance : new APIService();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withSpec(instance.getSpec());
            this.withStatus(instance.getStatus());
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withSpec(instance.getSpec());
            this.withStatus(instance.getStatus());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    @Override
    public APIService build() {
        APIService buildable = new APIService(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.buildMetadata(), this.fluent.buildSpec(), this.fluent.buildStatus());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

