package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class NodeBuilder extends NodeFluent<NodeBuilder> implements VisitableBuilder<Node,NodeBuilder>{
  public NodeBuilder() {
    this(new Node());
  }
  
  public NodeBuilder(NodeFluent<?> fluent) {
    this(fluent, new Node());
  }
  
  public NodeBuilder(NodeFluent<?> fluent,Node instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public NodeBuilder(Node instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  NodeFluent<?> fluent;
  
  public Node build() {
    Node buildable = new Node(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}