/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ResourceQuotaSpec;
import io.fabric8.kubernetes.api.model.ScopeSelector;
import io.fabric8.kubernetes.api.model.ScopeSelectorBuilder;
import io.fabric8.kubernetes.api.model.ScopeSelectorFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ResourceQuotaSpecFluent<A extends ResourceQuotaSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Quantity> hard;
    private ScopeSelectorBuilder scopeSelector;
    private List<String> scopes = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public ResourceQuotaSpecFluent() {
    }

    public ResourceQuotaSpecFluent(ResourceQuotaSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ResourceQuotaSpec instance) {
        ResourceQuotaSpec resourceQuotaSpec = instance = instance != null ? instance : new ResourceQuotaSpec();
        if (instance != null) {
            this.withHard(instance.getHard());
            this.withScopeSelector(instance.getScopeSelector());
            this.withScopes(instance.getScopes());
            this.withHard(instance.getHard());
            this.withScopeSelector(instance.getScopeSelector());
            this.withScopes(instance.getScopes());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToHard(String key, Quantity value) {
        if (this.hard == null && key != null && value != null) {
            this.hard = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.hard.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToHard(Map<String, Quantity> map) {
        if (this.hard == null && map != null) {
            this.hard = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.hard.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromHard(String key) {
        if (this.hard == null) {
            return (A)((Object)this);
        }
        if (key != null && this.hard != null) {
            this.hard.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromHard(Map<String, Quantity> map) {
        if (this.hard == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.hard == null) continue;
                this.hard.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Quantity> getHard() {
        return this.hard;
    }

    public <K, V> A withHard(Map<String, Quantity> hard) {
        this.hard = hard == null ? null : new LinkedHashMap<String, Quantity>(hard);
        return (A)((Object)this);
    }

    public boolean hasHard() {
        return this.hard != null;
    }

    public ScopeSelector buildScopeSelector() {
        return this.scopeSelector != null ? this.scopeSelector.build() : null;
    }

    public A withScopeSelector(ScopeSelector scopeSelector) {
        this._visitables.remove((Object)this.scopeSelector);
        if (scopeSelector != null) {
            this.scopeSelector = new ScopeSelectorBuilder(scopeSelector);
            this._visitables.get((Object)"scopeSelector").add(this.scopeSelector);
        } else {
            this.scopeSelector = null;
            this._visitables.get((Object)"scopeSelector").remove((Object)this.scopeSelector);
        }
        return (A)((Object)this);
    }

    public boolean hasScopeSelector() {
        return this.scopeSelector != null;
    }

    public ScopeSelectorNested<A> withNewScopeSelector() {
        return new ScopeSelectorNested(null);
    }

    public ScopeSelectorNested<A> withNewScopeSelectorLike(ScopeSelector item) {
        return new ScopeSelectorNested(item);
    }

    public ScopeSelectorNested<A> editScopeSelector() {
        return this.withNewScopeSelectorLike(Optional.ofNullable(this.buildScopeSelector()).orElse(null));
    }

    public ScopeSelectorNested<A> editOrNewScopeSelector() {
        return this.withNewScopeSelectorLike(Optional.ofNullable(this.buildScopeSelector()).orElse(new ScopeSelectorBuilder().build()));
    }

    public ScopeSelectorNested<A> editOrNewScopeSelectorLike(ScopeSelector item) {
        return this.withNewScopeSelectorLike(Optional.ofNullable(this.buildScopeSelector()).orElse(item));
    }

    public A addToScopes(int index, String item) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.add(index, item);
        return (A)((Object)this);
    }

    public A setToScopes(int index, String item) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.set(index, item);
        return (A)((Object)this);
    }

    public A addToScopes(String ... items) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        for (String item : items) {
            this.scopes.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToScopes(Collection<String> items) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        for (String item : items) {
            this.scopes.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromScopes(String ... items) {
        if (this.scopes == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.scopes.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromScopes(Collection<String> items) {
        if (this.scopes == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.scopes.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public String getScope(int index) {
        return this.scopes.get(index);
    }

    public String getFirstScope() {
        return this.scopes.get(0);
    }

    public String getLastScope() {
        return this.scopes.get(this.scopes.size() - 1);
    }

    public String getMatchingScope(Predicate<String> predicate) {
        for (String item : this.scopes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingScope(Predicate<String> predicate) {
        for (String item : this.scopes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withScopes(List<String> scopes) {
        if (scopes != null) {
            this.scopes = new ArrayList<String>();
            for (String item : scopes) {
                this.addToScopes(item);
            }
        } else {
            this.scopes = null;
        }
        return (A)((Object)this);
    }

    public A withScopes(String ... scopes) {
        if (this.scopes != null) {
            this.scopes.clear();
            this._visitables.remove((Object)"scopes");
        }
        if (scopes != null) {
            for (String item : scopes) {
                this.addToScopes(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasScopes() {
        return this.scopes != null && !this.scopes.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceQuotaSpecFluent that = (ResourceQuotaSpecFluent)((Object)o);
        if (!Objects.equals(this.hard, that.hard)) {
            return false;
        }
        if (!Objects.equals((Object)this.scopeSelector, (Object)that.scopeSelector)) {
            return false;
        }
        if (!Objects.equals(this.scopes, that.scopes)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.hard, this.scopeSelector, this.scopes, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.hard != null && !this.hard.isEmpty()) {
            sb.append("hard:");
            sb.append(this.hard + ",");
        }
        if (this.scopeSelector != null) {
            sb.append("scopeSelector:");
            sb.append((Object)((Object)this.scopeSelector) + ",");
        }
        if (this.scopes != null && !this.scopes.isEmpty()) {
            sb.append("scopes:");
            sb.append(this.scopes + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ScopeSelectorNested<N>
    extends ScopeSelectorFluent<ScopeSelectorNested<N>>
    implements Nested<N> {
        ScopeSelectorBuilder builder;

        ScopeSelectorNested(ScopeSelector item) {
            this.builder = new ScopeSelectorBuilder(this, item);
        }

        public N and() {
            return (N)ResourceQuotaSpecFluent.this.withScopeSelector(this.builder.build());
        }

        public N endScopeSelector() {
            return this.and();
        }
    }
}

